/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.util.registry.Registry;

public class GitCommand {
    public static final GitCommand ADD = GitCommand.write("add");
    public static final GitCommand BLAME = GitCommand.read("blame");
    public static final GitCommand BRANCH = GitCommand.read("branch");
    public static final GitCommand CHECKOUT = GitCommand.write("checkout");
    public static final GitCommand CHECK_ATTR = GitCommand.read("check-attr");
    public static final GitCommand COMMIT = GitCommand.write("commit");
    public static final GitCommand CONFIG = GitCommand.read("config");
    public static final GitCommand CHERRY = GitCommand.read("cherry");
    public static final GitCommand CHERRY_PICK = GitCommand.write("cherry-pick");
    public static final GitCommand CLONE = GitCommand.write("clone");
    public static final GitCommand DIFF = GitCommand.read("diff");
    public static final GitCommand FETCH = GitCommand.read("fetch");
    public static final GitCommand INIT = GitCommand.write("init");
    public static final GitCommand LOG = GitCommand.read("log");
    public static final GitCommand LS_FILES = GitCommand.read("ls-files");
    public static final GitCommand LS_REMOTE = GitCommand.read("ls-remote");
    public static final GitCommand MERGE = GitCommand.write("merge");
    public static final GitCommand MERGE_BASE = GitCommand.read("merge-base");
    public static final GitCommand PULL = GitCommand.write("pull");
    public static final GitCommand PUSH = GitCommand.write("push");
    public static final GitCommand REBASE = GitCommand.writeSuspendable("rebase");
    public static final GitCommand REMOTE = GitCommand.read("remote");
    public static final GitCommand RESET = GitCommand.write("reset");
    public static final GitCommand REV_LIST = GitCommand.read("rev-list");
    public static final GitCommand REV_PARSE = GitCommand.read("rev-parse");
    public static final GitCommand RM = GitCommand.write("rm");
    public static final GitCommand SHOW = GitCommand.read("show");
    public static final GitCommand STASH = GitCommand.write("stash");
    public static final GitCommand STATUS = Registry.is((String)"git.status.write") ? GitCommand.write("status") : GitCommand.read("status");
    public static final GitCommand TAG = GitCommand.read("tag");
    public static final GitCommand UPDATE_INDEX = GitCommand.write("update-index");
    public static final String GIT_EDITOR_ENV = "GIT_EDITOR";
    private final String myName;
    private final LockingPolicy myLocking;

    private GitCommand(String name, LockingPolicy lockingPolicy) {
        this.myLocking = lockingPolicy;
        this.myName = name;
    }

    private GitCommand(GitCommand command, LockingPolicy lockingPolicy) {
        this.myName = command.name();
        this.myLocking = lockingPolicy;
    }

    public GitCommand readLockingCommand() {
        return new GitCommand(this, LockingPolicy.READ);
    }

    private static GitCommand read(String name) {
        return new GitCommand(name, LockingPolicy.READ);
    }

    private static GitCommand write(String name) {
        return new GitCommand(name, LockingPolicy.WRITE);
    }

    private static GitCommand writeSuspendable(String name) {
        return new GitCommand(name, LockingPolicy.WRITE_SUSPENDABLE);
    }

    public String name() {
        return this.myName;
    }

    public LockingPolicy lockingPolicy() {
        return this.myLocking;
    }

    public String toString() {
        return this.myName;
    }

    static enum LockingPolicy {
        READ,
        WRITE,
        WRITE_SUSPENDABLE;

    }
}

