/*
 * Decompiled with CFR 0.152.
 */
package git4idea.cherrypick;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.cherrypick.VcsCherryPicker;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitResultHandler;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import git4idea.GitLocalBranch;
import git4idea.GitPlatformFacade;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitSimpleEventDetector;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.config.GitVcsSettings;
import git4idea.merge.GitConflictResolver;
import git4idea.repo.GitRepository;
import git4idea.util.UntrackedFilesNotifier;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.event.HyperlinkEvent;

public class GitCherryPicker
extends VcsCherryPicker {
    private static final String CHERRY_PICK_HEAD_FILE = "CHERRY_PICK_HEAD";
    private static final Logger LOG = Logger.getInstance(GitCherryPicker.class);
    private static final String NAME = "Cherry-Pick";
    private final Project myProject;
    private final Git myGit;
    private final GitPlatformFacade myPlatformFacade;
    private final ChangeListManager myChangeListManager;

    public GitCherryPicker(Project project, Git git, GitPlatformFacade platformFacade) {
        this.myProject = project;
        this.myGit = git;
        this.myPlatformFacade = platformFacade;
        this.myChangeListManager = this.myPlatformFacade.getChangeListManager(this.myProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cherryPick(List<VcsFullCommitDetails> commits) {
        Map commitsInRoots = DvcsUtil.groupCommitsByRoots(this.myPlatformFacade.getRepositoryManager(this.myProject), commits);
        ArrayList successfulCommits = ContainerUtil.newArrayList();
        ArrayList alreadyPicked = ContainerUtil.newArrayList();
        AccessToken token = DvcsUtil.workingTreeChangeStarted((Project)this.myProject);
        try {
            for (Map.Entry entry : commitsInRoots.entrySet()) {
                GitRepository repository = (GitRepository)entry.getKey();
                boolean result = this.cherryPick(repository, (List)entry.getValue(), successfulCommits, alreadyPicked);
                repository.update();
                if (result) continue;
                return;
            }
            this.notifyResult(successfulCommits, alreadyPicked);
        }
        finally {
            DvcsUtil.workingTreeChangeFinished((Project)this.myProject, (AccessToken)token);
        }
    }

    private boolean cherryPick(GitRepository repository, List<VcsFullCommitDetails> commits, List<GitCommitWrapper> successfulCommits, List<GitCommitWrapper> alreadyPicked) {
        for (VcsFullCommitDetails commit : commits) {
            GitSimpleEventDetector conflictDetector = new GitSimpleEventDetector(GitSimpleEventDetector.Event.CHERRY_PICK_CONFLICT);
            GitSimpleEventDetector localChangesOverwrittenDetector = new GitSimpleEventDetector(GitSimpleEventDetector.Event.LOCAL_CHANGES_OVERWRITTEN_BY_CHERRY_PICK);
            GitUntrackedFilesOverwrittenByOperationDetector untrackedFilesDetector = new GitUntrackedFilesOverwrittenByOperationDetector(repository.getRoot());
            boolean autoCommit = this.isAutoCommit();
            GitCommandResult result = this.myGit.cherryPick(repository, ((Hash)commit.getId()).asString(), autoCommit, conflictDetector, localChangesOverwrittenDetector, untrackedFilesDetector);
            GitCommitWrapper commitWrapper = new GitCommitWrapper(commit);
            if (result.success()) {
                if (autoCommit) {
                    successfulCommits.add(commitWrapper);
                    continue;
                }
                boolean committed = this.updateChangeListManagerShowCommitDialogAndRemoveChangeListOnSuccess(repository, commitWrapper, successfulCommits, alreadyPicked);
                if (committed) continue;
                this.notifyCommitCancelled(commitWrapper, successfulCommits);
                return false;
            }
            if (conflictDetector.hasHappened()) {
                boolean mergeCompleted = new CherryPickConflictResolver(this.myProject, this.myGit, this.myPlatformFacade, repository.getRoot(), ((Hash)commit.getId()).asString(), commit.getAuthor().getName(), commit.getSubject()).merge();
                if (mergeCompleted) {
                    boolean committed = this.updateChangeListManagerShowCommitDialogAndRemoveChangeListOnSuccess(repository, commitWrapper, successfulCommits, alreadyPicked);
                    if (committed) continue;
                    this.notifyCommitCancelled(commitWrapper, successfulCommits);
                    return false;
                }
                this.updateChangeListManager(commit);
                this.notifyConflictWarning(repository, commitWrapper, successfulCommits);
                return false;
            }
            if (untrackedFilesDetector.wasMessageDetected()) {
                String description = GitCherryPicker.commitDetails(commitWrapper) + "<br/>Some untracked working tree files would be overwritten by cherry-pick.<br/>" + "Please move, remove or add them before you can cherry-pick. <a href='view'>View them</a>";
                description = description + GitCherryPicker.getSuccessfulCommitDetailsIfAny(successfulCommits);
                UntrackedFilesNotifier.notifyUntrackedFilesOverwrittenBy(this.myProject, repository.getRoot(), untrackedFilesDetector.getRelativeFilePaths(), "cherry-pick", description);
                return false;
            }
            if (localChangesOverwrittenDetector.hasHappened()) {
                this.notifyError("Your local changes would be overwritten by cherry-pick.<br/>Commit your changes or stash them to proceed.", commitWrapper, successfulCommits);
                return false;
            }
            if (GitCherryPicker.isNothingToCommitMessage(result)) {
                alreadyPicked.add(commitWrapper);
                return true;
            }
            this.notifyError(result.getErrorOutputAsHtmlString(), commitWrapper, successfulCommits);
            return false;
        }
        return true;
    }

    private static boolean isNothingToCommitMessage(GitCommandResult result) {
        if (!result.getErrorOutputAsJoinedString().isEmpty()) {
            return false;
        }
        String stdout = result.getOutputAsJoinedString();
        return stdout.contains("nothing to commit") || stdout.contains("previous cherry-pick is now empty");
    }

    private boolean updateChangeListManagerShowCommitDialogAndRemoveChangeListOnSuccess(GitRepository repository, GitCommitWrapper commit, List<GitCommitWrapper> successfulCommits, List<GitCommitWrapper> alreadyPicked) {
        CherryPickData data = this.updateChangeListManager(commit.getCommit());
        if (data == null) {
            alreadyPicked.add(commit);
            return true;
        }
        boolean committed = this.showCommitDialogAndWaitForCommit(repository, commit, data.myChangeList, data.myCommitMessage);
        if (committed) {
            this.myChangeListManager.removeChangeList(data.myChangeList);
            successfulCommits.add(commit);
            return true;
        }
        return false;
    }

    private void notifyConflictWarning(GitRepository repository, GitCommitWrapper commit, List<GitCommitWrapper> successfulCommits) {
        ResolveLinkListener resolveLinkListener = new ResolveLinkListener(this.myProject, this.myGit, this.myPlatformFacade, repository.getRoot(), ((Hash)commit.getCommit().getId()).toShortString(), commit.getCommit().getAuthor().getName(), commit.getSubject());
        String description = GitCherryPicker.commitDetails(commit) + "<br/>Unresolved conflicts remain in the working tree. <a href='resolve'>Resolve them.<a/>";
        description = description + GitCherryPicker.getSuccessfulCommitDetailsIfAny(successfulCommits);
        VcsNotifier.getInstance((Project)this.myProject).notifyImportantWarning("Cherry-picked with conflicts", description, (NotificationListener)resolveLinkListener);
    }

    private void notifyCommitCancelled(GitCommitWrapper commit, List<GitCommitWrapper> successfulCommits) {
        if (successfulCommits.isEmpty()) {
            return;
        }
        String description = GitCherryPicker.commitDetails(commit);
        description = description + GitCherryPicker.getSuccessfulCommitDetailsIfAny(successfulCommits);
        VcsNotifier.getInstance((Project)this.myProject).notifyMinorWarning("Cherry-pick cancelled", description, null);
    }

    private CherryPickData updateChangeListManager(VcsFullCommitDetails commit) {
        Collection changes = commit.getChanges();
        RefreshVFsSynchronously.updateChanges((Collection)changes);
        String commitMessage = GitCherryPicker.createCommitMessage(commit);
        List paths = ChangesUtil.getPaths((Collection)changes);
        LocalChangeList changeList = this.createChangeListAfterUpdate(commit, paths, commitMessage);
        return changeList == null ? null : new CherryPickData(changeList, commitMessage);
    }

    private LocalChangeList createChangeListAfterUpdate(final VcsFullCommitDetails commit, final Collection<FilePath> paths, final String commitMessage) {
        final CountDownLatch waiter = new CountDownLatch(1);
        final AtomicReference changeList = new AtomicReference();
        this.myPlatformFacade.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                GitCherryPicker.this.myChangeListManager.invokeAfterUpdate(new Runnable(){

                    @Override
                    public void run() {
                        changeList.set(GitCherryPicker.this.createChangeListIfThereAreChanges(commit, commitMessage));
                        waiter.countDown();
                    }
                }, InvokeAfterUpdateMode.SILENT_CALLBACK_POOLED, "Cherry-pick", (Consumer)new Consumer<VcsDirtyScopeManager>(){

                    public void consume(VcsDirtyScopeManager vcsDirtyScopeManager) {
                        vcsDirtyScopeManager.filePathsDirty(paths, null);
                    }
                }, ModalityState.NON_MODAL);
            }
        }, ModalityState.NON_MODAL);
        try {
            boolean success = waiter.await(100L, TimeUnit.SECONDS);
            if (!success) {
                LOG.error("Couldn't await for change list manager refresh");
            }
        }
        catch (InterruptedException e) {
            LOG.error((Throwable)e);
            return null;
        }
        return (LocalChangeList)changeList.get();
    }

    private static String createCommitMessage(VcsFullCommitDetails commit) {
        return commit.getFullMessage() + "\n(cherry picked from commit " + ((Hash)commit.getId()).toShortString() + ")";
    }

    private boolean showCommitDialogAndWaitForCommit(final GitRepository repository, final GitCommitWrapper commit, final LocalChangeList changeList, final String commitMessage) {
        final AtomicBoolean commitSucceeded = new AtomicBoolean();
        final Semaphore sem = new Semaphore(0);
        this.myPlatformFacade.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    GitCherryPicker.this.cancelCherryPick(repository);
                    Collection changes = commit.getCommit().getChanges();
                    boolean commitNotCancelled = GitCherryPicker.this.myPlatformFacade.getVcsHelper(GitCherryPicker.this.myProject).commitChanges(changes, changeList, commitMessage, new CommitResultHandler(){

                        public void onSuccess(String commitMessage) {
                            commit.setActualSubject(commitMessage);
                            commitSucceeded.set(true);
                            sem.release();
                        }

                        public void onFailure() {
                            commitSucceeded.set(false);
                            sem.release();
                        }
                    });
                    if (!commitNotCancelled) {
                        commitSucceeded.set(false);
                        sem.release();
                    }
                }
                catch (Throwable t) {
                    LOG.error(t);
                    commitSucceeded.set(false);
                    sem.release();
                }
            }
        }, ModalityState.NON_MODAL);
        try {
            sem.acquire();
        }
        catch (InterruptedException e) {
            LOG.error((Throwable)e);
            return false;
        }
        return commitSucceeded.get();
    }

    private void cancelCherryPick(GitRepository repository) {
        if (this.isAutoCommit()) {
            this.removeCherryPickHead(repository);
        }
    }

    private void removeCherryPickHead(GitRepository repository) {
        File cherryPickHeadFile = new File(repository.getGitDir().getPath(), CHERRY_PICK_HEAD_FILE);
        final VirtualFile cherryPickHead = this.myPlatformFacade.getLocalFileSystem().refreshAndFindFileByIoFile(cherryPickHeadFile);
        if (cherryPickHead != null && cherryPickHead.exists()) {
            this.myPlatformFacade.runWriteAction(new Runnable(){

                @Override
                public void run() {
                    try {
                        cherryPickHead.delete((Object)this);
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                }
            });
        } else {
            LOG.info("Cancel cherry-pick in " + repository.getPresentableUrl() + ": no CHERRY_PICK_HEAD found");
        }
    }

    private void notifyError(String content, GitCommitWrapper failedCommit, List<GitCommitWrapper> successfulCommits) {
        String description = GitCherryPicker.commitDetails(failedCommit) + "<br/>" + content;
        description = description + GitCherryPicker.getSuccessfulCommitDetailsIfAny(successfulCommits);
        VcsNotifier.getInstance((Project)this.myProject).notifyError("Cherry-pick failed", description);
    }

    private static String getSuccessfulCommitDetailsIfAny(List<GitCommitWrapper> successfulCommits) {
        String description = "";
        if (!successfulCommits.isEmpty()) {
            description = description + "<hr/>However cherry-pick succeeded for the following " + StringUtil.pluralize((String)"commit", (int)successfulCommits.size()) + ":<br/>";
            description = description + GitCherryPicker.getCommitsDetails(successfulCommits);
        }
        return description;
    }

    private void notifyResult(List<GitCommitWrapper> successfulCommits, List<GitCommitWrapper> alreadyPicked) {
        if (alreadyPicked.isEmpty()) {
            VcsNotifier.getInstance((Project)this.myProject).notifySuccess("Cherry-pick successful", GitCherryPicker.getCommitsDetails(successfulCommits));
        } else if (!successfulCommits.isEmpty()) {
            String title = String.format("Cherry-picked %d commits from %d", successfulCommits.size(), successfulCommits.size() + alreadyPicked.size());
            String description = GitCherryPicker.getCommitsDetails(successfulCommits) + "<hr/>" + GitCherryPicker.formAlreadyPickedDescription(alreadyPicked, true);
            VcsNotifier.getInstance((Project)this.myProject).notifySuccess(title, description);
        } else {
            VcsNotifier.getInstance((Project)this.myProject).notifyImportantWarning("Nothing to cherry-pick", GitCherryPicker.formAlreadyPickedDescription(alreadyPicked, false));
        }
    }

    private static String formAlreadyPickedDescription(List<GitCommitWrapper> alreadyPicked, boolean but) {
        String hashes = StringUtil.join(alreadyPicked, (Function)new Function<GitCommitWrapper, String>(){

            public String fun(GitCommitWrapper commit) {
                return ((Hash)commit.getCommit().getId()).toShortString();
            }
        }, (String)", ");
        if (but) {
            String wasnt = alreadyPicked.size() == 1 ? "wasn't" : "weren't";
            String it = alreadyPicked.size() == 1 ? "it" : "them";
            return String.format("%s %s picked, because all changes from %s have already been applied.", hashes, wasnt, it);
        }
        return String.format("All changes from %s have already been applied", hashes);
    }

    private static String getCommitsDetails(List<GitCommitWrapper> successfulCommits) {
        String description = "";
        for (GitCommitWrapper commit : successfulCommits) {
            description = description + GitCherryPicker.commitDetails(commit) + "<br/>";
        }
        return description.substring(0, description.length() - "<br/>".length());
    }

    private static String commitDetails(GitCommitWrapper commit) {
        return ((Hash)commit.getCommit().getId()).toShortString() + " " + commit.getOriginalSubject();
    }

    private LocalChangeList createChangeListIfThereAreChanges(VcsFullCommitDetails commit, String commitMessage) {
        Collection originalChanges = commit.getChanges();
        if (originalChanges.isEmpty()) {
            LOG.info("Empty commit " + commit.getId());
            return null;
        }
        if (this.noChangesAfterCherryPick(originalChanges)) {
            LOG.info("No changes after cherry-picking " + commit.getId());
            return null;
        }
        String changeListName = this.createNameForChangeList(commitMessage, 0).replace('\n', ' ');
        LocalChangeList createdChangeList = ((ChangeListManagerEx)this.myChangeListManager).addChangeList(changeListName, commitMessage, (Object)commit);
        LocalChangeList actualChangeList = this.moveChanges(originalChanges, createdChangeList);
        if (actualChangeList != null && !actualChangeList.getChanges().isEmpty()) {
            return createdChangeList;
        }
        LOG.warn("No changes were moved to the changelist. Changes from commit: " + originalChanges + "\nAll changes: " + this.myChangeListManager.getAllChanges());
        this.myChangeListManager.removeChangeList(createdChangeList);
        return null;
    }

    private boolean noChangesAfterCherryPick(Collection<Change> originalChanges) {
        final Collection allChanges = this.myChangeListManager.getAllChanges();
        return !ContainerUtil.exists(originalChanges, (Condition)new Condition<Change>(){

            public boolean value(Change change) {
                return allChanges.contains(change);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalChangeList moveChanges(Collection<Change> originalChanges, final LocalChangeList targetChangeList) {
        final CountDownLatch moveChangesWaiter = new CountDownLatch(1);
        final AtomicReference resultingChangeList = new AtomicReference();
        ChangeListAdapter listener = new ChangeListAdapter(){

            public void changesMoved(Collection<Change> changes, ChangeList fromList, ChangeList toList) {
                if (toList instanceof LocalChangeList && targetChangeList.getId().equals(((LocalChangeList)toList).getId())) {
                    resultingChangeList.set((LocalChangeList)toList);
                    moveChangesWaiter.countDown();
                }
            }
        };
        try {
            this.myChangeListManager.addChangeListListener((ChangeListListener)listener);
            this.myChangeListManager.moveChangesTo(targetChangeList, originalChanges.toArray(new Change[originalChanges.size()]));
            boolean success = moveChangesWaiter.await(100L, TimeUnit.SECONDS);
            if (!success) {
                LOG.error("Couldn't await for changes move.");
            }
            LocalChangeList localChangeList = (LocalChangeList)resultingChangeList.get();
            return localChangeList;
        }
        catch (InterruptedException e) {
            LOG.error((Throwable)e);
            LocalChangeList localChangeList = null;
            return localChangeList;
        }
        finally {
            this.myChangeListManager.removeChangeListListener((ChangeListListener)listener);
        }
    }

    private String createNameForChangeList(String proposedName, int step) {
        for (LocalChangeList list : this.myChangeListManager.getChangeLists()) {
            if (!list.getName().equals(GitCherryPicker.nameWithStep(proposedName, step))) continue;
            return this.createNameForChangeList(proposedName, step + 1);
        }
        return GitCherryPicker.nameWithStep(proposedName, step);
    }

    private static String nameWithStep(String name, int step) {
        return step == 0 ? name : name + "-" + step;
    }

    public VcsKey getSupportedVcs() {
        return GitVcs.getKey();
    }

    public String getActionTitle() {
        return this.isAutoCommit() ? NAME : "Cherry-Pick...";
    }

    private boolean isAutoCommit() {
        return GitVcsSettings.getInstance(this.myProject).isAutoCommitOnCherryPick();
    }

    public boolean isEnabled(VcsLog log, List<VcsFullCommitDetails> details) {
        if (details.isEmpty()) {
            return false;
        }
        for (VcsFullCommitDetails commit : details) {
            GitRepository repository = (GitRepository)this.myPlatformFacade.getRepositoryManager(this.myProject).getRepositoryForRoot(commit.getRoot());
            if (repository == null) {
                return false;
            }
            GitLocalBranch currentBranch = repository.getCurrentBranch();
            Collection containingBranches = log.getContainingBranches((Hash)commit.getId());
            if (currentBranch == null || containingBranches == null || !containingBranches.contains(currentBranch.getName())) continue;
            return false;
        }
        return true;
    }

    private static class GitCommitWrapper {
        private final VcsFullCommitDetails myOriginalCommit;
        private String myActualSubject;

        private GitCommitWrapper(VcsFullCommitDetails commit) {
            this.myOriginalCommit = commit;
            this.myActualSubject = commit.getSubject();
        }

        public String getSubject() {
            return this.myActualSubject;
        }

        public void setActualSubject(String actualSubject) {
            this.myActualSubject = actualSubject;
        }

        public VcsFullCommitDetails getCommit() {
            return this.myOriginalCommit;
        }

        public String getOriginalSubject() {
            return this.myOriginalCommit.getSubject();
        }
    }

    private static class CherryPickMergeDialogCustomizer
    extends MergeDialogCustomizer {
        private String myCommitHash;
        private String myCommitAuthor;
        private String myCommitMessage;

        public CherryPickMergeDialogCustomizer(String commitHash, String commitAuthor, String commitMessage) {
            this.myCommitHash = commitHash;
            this.myCommitAuthor = commitAuthor;
            this.myCommitMessage = commitMessage;
        }

        public String getMultipleFileMergeDescription(Collection<VirtualFile> files) {
            return "<html>Conflicts during cherry-picking commit <code>" + this.myCommitHash + "</code> made by " + this.myCommitAuthor + "<br/>" + "<code>\"" + this.myCommitMessage + "\"</code></html>";
        }

        public String getLeftPanelTitle(VirtualFile file) {
            return "Local changes";
        }

        public String getRightPanelTitle(VirtualFile file, VcsRevisionNumber lastRevisionNumber) {
            return "<html>Changes from cherry-pick <code>" + this.myCommitHash + "</code>";
        }
    }

    private static class ResolveLinkListener
    implements NotificationListener {
        private final Project myProject;
        private final Git myGit;
        private final GitPlatformFacade myFacade;
        private final VirtualFile myRoot;
        private final String myHash;
        private final String myAuthor;
        private final String myMessage;

        public ResolveLinkListener(Project project, Git git, GitPlatformFacade facade, VirtualFile root, String commitHash, String commitAuthor, String commitMessage) {
            this.myProject = project;
            this.myGit = git;
            this.myFacade = facade;
            this.myRoot = root;
            this.myHash = commitHash;
            this.myAuthor = commitAuthor;
            this.myMessage = commitMessage;
        }

        public void hyperlinkUpdate(Notification notification, HyperlinkEvent event) {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && event.getDescription().equals("resolve")) {
                new CherryPickConflictResolver(this.myProject, this.myGit, this.myFacade, this.myRoot, this.myHash, this.myAuthor, this.myMessage).mergeNoProceed();
            }
        }
    }

    private static class CherryPickConflictResolver
    extends GitConflictResolver {
        public CherryPickConflictResolver(Project project, Git git, GitPlatformFacade facade, VirtualFile root, String commitHash, String commitAuthor, String commitMessage) {
            super(project, git, facade, Collections.singleton(root), CherryPickConflictResolver.makeParams(commitHash, commitAuthor, commitMessage));
        }

        private static GitConflictResolver.Params makeParams(String commitHash, String commitAuthor, String commitMessage) {
            GitConflictResolver.Params params = new GitConflictResolver.Params();
            params.setErrorNotificationTitle("Cherry-picked with conflicts");
            params.setMergeDialogCustomizer(new CherryPickMergeDialogCustomizer(commitHash, commitAuthor, commitMessage));
            return params;
        }

        @Override
        protected void notifyUnresolvedRemain() {
        }
    }

    private static class CherryPickData {
        private final LocalChangeList myChangeList;
        private final String myCommitMessage;

        private CherryPickData(LocalChangeList list, String message) {
            this.myChangeList = list;
            this.myCommitMessage = message;
        }
    }
}

