/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkout;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitVcs;
import git4idea.actions.BasicAction;
import git4idea.checkout.GitCloneDialog;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitStandardProgressAnalyzer;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;

public class GitCheckoutProvider
implements CheckoutProvider {
    private final Git myGit;

    public GitCheckoutProvider(Git git) {
        this.myGit = git;
    }

    public String getVcsName() {
        return "_Git";
    }

    public void doCheckout(Project project, CheckoutProvider.Listener listener) {
        BasicAction.saveAll();
        GitCloneDialog dialog = new GitCloneDialog(project);
        if (!dialog.showAndGet()) {
            return;
        }
        dialog.rememberSettings();
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        File parent = new File(dialog.getParentDirectory());
        VirtualFile destinationParent = lfs.findFileByIoFile(parent);
        if (destinationParent == null) {
            destinationParent = lfs.refreshAndFindFileByIoFile(parent);
        }
        if (destinationParent == null) {
            return;
        }
        String sourceRepositoryURL = dialog.getSourceRepositoryURL();
        String directoryName = dialog.getDirectoryName();
        String parentDirectory = dialog.getParentDirectory();
        GitCheckoutProvider.clone(project, this.myGit, listener, destinationParent, sourceRepositoryURL, directoryName, parentDirectory);
    }

    public static void clone(final Project project, final Git git, final CheckoutProvider.Listener listener, final VirtualFile destinationParent, final String sourceRepositoryURL, final String directoryName, final String parentDirectory) {
        final AtomicBoolean cloneResult = new AtomicBoolean();
        new Task.Backgroundable(project, DvcsBundle.message((String)"cloning.repository", (Object[])new Object[]{sourceRepositoryURL})){

            public void run(ProgressIndicator indicator) {
                cloneResult.set(GitCheckoutProvider.doClone(project, git, directoryName, parentDirectory, sourceRepositoryURL));
            }

            public void onSuccess() {
                if (!cloneResult.get()) {
                    return;
                }
                DvcsUtil.addMappingIfSubRoot((Project)project, (String)FileUtil.join((String[])new String[]{parentDirectory, directoryName}), (String)"Git");
                destinationParent.refresh(true, true, new Runnable(){

                    @Override
                    public void run() {
                        if (project.isOpen() && !project.isDisposed() && !project.isDefault()) {
                            VcsDirtyScopeManager mgr = VcsDirtyScopeManager.getInstance((Project)project);
                            mgr.fileDirty(destinationParent);
                        }
                    }
                });
                listener.directoryCheckedOut(new File(parentDirectory, directoryName), GitVcs.getKey());
                listener.checkoutCompleted();
            }
        }.queue();
    }

    public static boolean doClone(Project project, Git git, String directoryName, String parentDirectory, String sourceRepositoryURL) {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        indicator.setIndeterminate(false);
        GitLineHandlerListener progressListener = GitStandardProgressAnalyzer.createListener(indicator);
        GitCommandResult result = git.clone(project, new File(parentDirectory), sourceRepositoryURL, directoryName, progressListener);
        if (result.success()) {
            return true;
        }
        VcsNotifier.getInstance((Project)project).notifyError("Clone failed", result.getErrorOutputAsHtmlString());
        return false;
    }
}

