/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.SelectFilesDialog;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.GitCommit;
import git4idea.GitPlatformFacade;
import git4idea.GitUtil;
import git4idea.MessageManager;
import git4idea.branch.GitBranchIsNotFullyMergedDialog;
import git4idea.branch.GitBranchUiHandler;
import git4idea.branch.GitSmartOperationDialog;
import git4idea.commands.Git;
import git4idea.merge.GitConflictResolver;
import git4idea.repo.GitRepository;
import git4idea.ui.ChangesBrowserWithRollback;
import git4idea.util.GitSimplePathsBrowser;
import git4idea.util.UntrackedFilesNotifier;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.plaf.LabelUI;

public class GitBranchUiHandlerImpl
implements GitBranchUiHandler {
    private final Project myProject;
    private final Git myGit;
    private final GitPlatformFacade myFacade;
    private final ProgressIndicator myProgressIndicator;

    public GitBranchUiHandlerImpl(Project project, GitPlatformFacade facade, Git git, ProgressIndicator indicator) {
        this.myProject = project;
        this.myGit = git;
        this.myFacade = facade;
        this.myProgressIndicator = indicator;
    }

    @Override
    public boolean notifyErrorWithRollbackProposal(final String title, final String message, final String rollbackProposal) {
        final AtomicBoolean ok = new AtomicBoolean();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                StringBuilder description = new StringBuilder();
                if (!StringUtil.isEmptyOrSpaces((String)message)) {
                    description.append(message).append("<br/>");
                }
                description.append(rollbackProposal);
                ok.set(0 == MessageManager.showYesNoDialog(GitBranchUiHandlerImpl.this.myProject, XmlStringUtil.wrapInHtml((CharSequence)description), title, "Rollback", "Don't rollback", Messages.getErrorIcon()));
            }
        });
        return ok.get();
    }

    @Override
    public void showUnmergedFilesNotification(final String operationName, final Collection<GitRepository> repositories) {
        String title = GitBranchUiHandlerImpl.unmergedFilesErrorTitle(operationName);
        String description = GitBranchUiHandlerImpl.unmergedFilesErrorNotificationDescription(operationName);
        VcsNotifier.getInstance((Project)this.myProject).notifyError(title, description, new NotificationListener(){

            public void hyperlinkUpdate(Notification notification, HyperlinkEvent event) {
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && event.getDescription().equals("resolve")) {
                    GitConflictResolver.Params params = new GitConflictResolver.Params().setMergeDescription(String.format("The following files have unresolved conflicts. You need to resolve them before %s.", operationName)).setErrorNotificationTitle("Unresolved files remain.");
                    new GitConflictResolver(GitBranchUiHandlerImpl.this.myProject, GitBranchUiHandlerImpl.this.myGit, GitBranchUiHandlerImpl.this.myFacade, GitUtil.getRootsFromRepositories(repositories), params).merge();
                }
            }
        });
    }

    @Override
    public boolean showUnmergedFilesMessageWithRollback(final String operationName, final String rollbackProposal) {
        final AtomicBoolean ok = new AtomicBoolean();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                String description = String.format("<html>You have to resolve all merge conflicts before %s.<br/>%s</html>", operationName, rollbackProposal);
                ok.set(0 == MessageManager.showYesNoDialog(GitBranchUiHandlerImpl.this.myProject, description, GitBranchUiHandlerImpl.unmergedFilesErrorTitle(operationName), "Rollback", "Don't rollback", Messages.getErrorIcon()));
            }
        });
        return ok.get();
    }

    @Override
    public void showUntrackedFilesNotification(String operationName, VirtualFile root, Collection<String> relativePaths) {
        UntrackedFilesNotifier.notifyUntrackedFilesOverwrittenBy(this.myProject, root, relativePaths, operationName, null);
    }

    @Override
    public boolean showUntrackedFilesDialogWithRollback(String operationName, final String rollbackProposal, VirtualFile root, Collection<String> relativePaths) {
        final String title = "Could not " + StringUtil.capitalize((String)operationName);
        final String description = UntrackedFilesNotifier.createUntrackedFilesOverwrittenDescription(operationName, false);
        final Collection<String> absolutePaths = GitUtil.toAbsolute(root, relativePaths);
        final List untrackedFiles = ContainerUtil.mapNotNull(absolutePaths, (Function)new Function<String, VirtualFile>(){

            public VirtualFile fun(String absolutePath) {
                return GitUtil.findRefreshFileOrLog(absolutePath);
            }
        });
        return (Boolean)UIUtil.invokeAndWaitIfNeeded((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                GitSimplePathsBrowser filesBrowser = untrackedFiles.isEmpty() ? new GitSimplePathsBrowser(GitBranchUiHandlerImpl.this.myProject, absolutePaths) : new SelectFilesDialog.VirtualFileList(GitBranchUiHandlerImpl.this.myProject, untrackedFiles, false, false);
                UntrackedFilesRollBackDialog dialog = new UntrackedFilesRollBackDialog(GitBranchUiHandlerImpl.this.myProject, filesBrowser, StringUtil.stripHtml((String)description, (boolean)true), rollbackProposal);
                dialog.setTitle(title);
                GitBranchUiHandlerImpl.this.myFacade.showDialog(dialog);
                return dialog.isOK();
            }
        });
    }

    @Override
    public ProgressIndicator getProgressIndicator() {
        return this.myProgressIndicator;
    }

    @Override
    public int showSmartOperationDialog(Project project, List<Change> changes, Collection<String> paths, String operation, String forceButtonTitle) {
        Object fileBrowser = !changes.isEmpty() ? new ChangesBrowserWithRollback(project, changes) : new GitSimplePathsBrowser(project, paths);
        return GitSmartOperationDialog.showAndGetAnswer(this.myProject, (JComponent)fileBrowser, operation, forceButtonTitle);
    }

    @Override
    public boolean showBranchIsNotFullyMergedDialog(Project project, final Map<GitRepository, List<GitCommit>> history, final String unmergedBranch, final List<String> mergedToBranches, final String baseBranch) {
        final AtomicBoolean forceDelete = new AtomicBoolean();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                forceDelete.set(GitBranchIsNotFullyMergedDialog.showAndGetAnswer(GitBranchUiHandlerImpl.this.myProject, history, unmergedBranch, mergedToBranches, baseBranch));
            }
        });
        return forceDelete.get();
    }

    private static String unmergedFilesErrorTitle(String operationName) {
        return "Can't " + operationName + " because of unmerged files";
    }

    private static String unmergedFilesErrorNotificationDescription(String operationName) {
        return "You have to <a href='resolve'>resolve</a> all merge conflicts before " + operationName + ".<br/>" + "After resolving conflicts you also probably would want to commit your files to the current branch.";
    }

    private static class UntrackedFilesRollBackDialog
    extends DialogWrapper {
        private final JComponent myFilesBrowser;
        private final String myPrompt;
        private final String myRollbackProposal;

        public UntrackedFilesRollBackDialog(Project project, JComponent filesBrowser, String prompt, String rollbackProposal) {
            super(project);
            this.myFilesBrowser = filesBrowser;
            this.myPrompt = prompt;
            this.myRollbackProposal = rollbackProposal;
            this.setOKButtonText("Rollback");
            this.setCancelButtonText("Don't rollback");
            this.init();
        }

        protected JComponent createSouthPanel() {
            JComponent buttons = super.createSouthPanel();
            JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
            panel.add((Component)new JBLabel(XmlStringUtil.wrapInHtml((CharSequence)this.myRollbackProposal)));
            panel.add(buttons);
            return panel;
        }

        protected JComponent createCenterPanel() {
            return this.myFilesBrowser;
        }

        protected JComponent createNorthPanel() {
            JLabel label = new JLabel(this.myPrompt);
            label.setUI((LabelUI)new MultiLineLabelUI());
            label.setBorder(new EmptyBorder(5, 1, 5, 1));
            return label;
        }
    }
}

