/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitPlatformFacade;
import git4idea.actions.GitRepositoryAction;
import git4idea.commands.GitHandlerUtil;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.ui.GitStashDialog;
import java.util.List;
import java.util.Set;

public class GitStash
extends GitRepositoryAction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void perform(Project project, List<VirtualFile> gitRoots, VirtualFile defaultRoot, Set<VirtualFile> affectedRoots, List<VcsException> exceptions) throws VcsException {
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        if (changeListManager.isFreezedWithNotification("Can not stash changes now")) {
            return;
        }
        GitStashDialog d = new GitStashDialog(project, gitRoots, defaultRoot);
        if (!d.showAndGet()) {
            return;
        }
        VirtualFile root = d.getGitRoot();
        affectedRoots.add(root);
        GitLineHandler h = d.handler();
        AccessToken token = DvcsUtil.workingTreeChangeStarted((Project)project);
        try {
            GitHandlerUtil.doSynchronously(h, GitBundle.getString("stashing.title"), h.printableCommandLine());
        }
        finally {
            DvcsUtil.workingTreeChangeFinished((Project)project, (AccessToken)token);
        }
        ((GitPlatformFacade)ServiceManager.getService((Project)project, GitPlatformFacade.class)).hardRefresh(root);
    }

    @Override
    protected String getActionName() {
        return GitBundle.getString("stash.action.name");
    }
}

