/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.actions.GitMergeAction;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitPullDialog;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.List;

public class GitPull
extends GitMergeAction {
    @Override
    protected String getActionName() {
        return GitBundle.getString("pull.action.name");
    }

    @Override
    protected GitMergeAction.DialogState displayDialog(Project project, List<VirtualFile> gitRoots, VirtualFile defaultRoot) {
        String url;
        final GitPullDialog dialog = new GitPullDialog(project, gitRoots, defaultRoot);
        if (!dialog.showAndGet()) {
            return null;
        }
        GitRepositoryManager repositoryManager = GitUtil.getRepositoryManager(project);
        GitRepository repository = (GitRepository)repositoryManager.getRepositoryForRoot(dialog.gitRoot());
        assert (repository != null) : "Repository can't be null for root " + dialog.gitRoot();
        String remoteOrUrl = dialog.getRemote();
        GitRemote remote = GitUtil.findRemoteByName(repository, remoteOrUrl);
        String string = url = remote == null ? remoteOrUrl : remote.getFirstUrl();
        if (url == null) {
            return null;
        }
        Computable<GitLineHandler> handlerProvider = new Computable<GitLineHandler>(){

            public GitLineHandler compute() {
                return dialog.makeHandler(url);
            }
        };
        return new GitMergeAction.DialogState(dialog.gitRoot(), GitBundle.message("pulling.title", dialog.getRemote()), handlerProvider);
    }
}

