/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.actions.GitRebaseActionBase;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitInteractiveRebaseEditorHandler;
import git4idea.rebase.GitRebaseActionDialog;
import git4idea.rebase.GitRebaseUtils;
import java.util.Iterator;
import java.util.List;

public abstract class GitAbstractRebaseResumeAction
extends GitRebaseActionBase {
    @Override
    protected GitLineHandler createHandler(Project project, List<VirtualFile> gitRoots, VirtualFile defaultRoot) {
        VirtualFile root;
        Iterator<VirtualFile> i = gitRoots.iterator();
        while (i.hasNext()) {
            if (GitRebaseUtils.isRebaseInTheProgress(i.next())) continue;
            i.remove();
        }
        if (gitRoots.size() == 0) {
            Messages.showErrorDialog((Project)project, (String)GitBundle.getString("rebase.action.no.root"), (String)GitBundle.getString("rebase.action.error"));
            return null;
        }
        if (gitRoots.size() == 1) {
            root = gitRoots.get(0);
        } else {
            if (!gitRoots.contains(defaultRoot)) {
                defaultRoot = gitRoots.get(0);
            }
            GitRebaseActionDialog d = new GitRebaseActionDialog(project, this.getActionTitle(), gitRoots, defaultRoot);
            d.show();
            root = d.selectRoot();
            if (root == null) {
                return null;
            }
        }
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.REBASE);
        h.setStdoutSuppressed(false);
        h.addParameters(this.getOptionName());
        return h;
    }

    @Override
    protected void configureEditor(GitInteractiveRebaseEditorHandler editor) {
        editor.setRebaseEditorShown();
    }

    protected abstract String getOptionName();

    protected abstract String getActionTitle();

    @Override
    protected boolean isEnabled(AnActionEvent e) {
        return super.isEnabled(e) && GitAbstractRebaseResumeAction.isRebasing(e);
    }
}

