/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitVcs;
import git4idea.util.GitUIUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class BasicAction
extends DumbAwareAction {
    public void actionPerformed(AnActionEvent event) {
        final Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                FileDocumentManager.getInstance().saveAllDocuments();
            }
        });
        VirtualFile[] vFiles = (VirtualFile[])event.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        assert (vFiles != null) : "The action is only available when files are selected";
        assert (project != null);
        GitVcs vcs = GitVcs.getInstance(project);
        if (!ProjectLevelVcsManager.getInstance((Project)project).checkAllFilesAreUnder((AbstractVcs)vcs, vFiles)) {
            return;
        }
        final String actionName = this.getActionName();
        final ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        final VirtualFile[] affectedFiles = this.collectAffectedFiles(project, vFiles);
        boolean background = this.perform(project, vcs, exceptions, affectedFiles);
        if (!background) {
            GitVcs.runInBackground(new Task.Backgroundable(project, this.getActionName()){

                public void run(ProgressIndicator indicator) {
                    VcsFileUtil.refreshFiles((Project)project, Arrays.asList(affectedFiles));
                    UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            GitUIUtil.showOperationErrors(project, exceptions, actionName);
                        }
                    });
                }
            });
        }
    }

    protected abstract boolean perform(Project var1, GitVcs var2, List<VcsException> var3, VirtualFile[] var4);

    protected boolean toBackground(final Project project, GitVcs vcs, final VirtualFile[] affectedFiles, final List<VcsException> exceptions, final Consumer<ProgressIndicator> action) {
        GitVcs.runInBackground(new Task.Backgroundable(project, this.getActionName()){

            public void run(ProgressIndicator indicator) {
                action.consume((Object)indicator);
                VcsFileUtil.refreshFiles((Project)project, Arrays.asList(affectedFiles));
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        GitUIUtil.showOperationErrors(project, exceptions, BasicAction.this.getActionName());
                    }
                });
            }
        });
        return true;
    }

    protected VirtualFile[] collectAffectedFiles(Project project, VirtualFile[] files) {
        ArrayList<VirtualFile> affectedFiles = new ArrayList<VirtualFile>(files.length);
        ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        for (VirtualFile file : files) {
            if (!file.isDirectory() && projectLevelVcsManager.getVcsFor(file) instanceof GitVcs) {
                affectedFiles.add(file);
                continue;
            }
            if (!file.isDirectory() || !this.isRecursive()) continue;
            this.addChildren(project, affectedFiles, file);
        }
        return VfsUtilCore.toVirtualFileArray(affectedFiles);
    }

    private void addChildren(final Project project, final List<VirtualFile> files, VirtualFile file) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[]{VirtualFileVisitor.SKIP_ROOT, this.isRecursive() ? null : VirtualFileVisitor.ONE_LEVEL_DEEP}){

            public boolean visitFile(VirtualFile file) {
                if (!file.isDirectory() && BasicAction.this.appliesTo(project, file)) {
                    files.add(file);
                }
                return true;
            }
        });
    }

    protected abstract String getActionName();

    protected boolean isRecursive() {
        return true;
    }

    protected boolean appliesTo(Project project, VirtualFile file) {
        return !file.isDirectory();
    }

    public void update(AnActionEvent e) {
        super.update(e);
        Presentation presentation = e.getPresentation();
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
            return;
        }
        VirtualFile[] vFiles = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (vFiles == null || vFiles.length == 0) {
            presentation.setEnabled(false);
            presentation.setVisible(true);
            return;
        }
        GitVcs vcs = GitVcs.getInstance(project);
        boolean enabled = ProjectLevelVcsManager.getInstance((Project)project).checkAllFilesAreUnder((AbstractVcs)vcs, vFiles) && this.isEnabled(project, vcs, vFiles);
        presentation.setEnabled(enabled);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            presentation.setVisible(enabled);
        } else {
            presentation.setVisible(true);
        }
    }

    protected abstract boolean isEnabled(Project var1, GitVcs var2, VirtualFile ... var3);

    public static void saveAll() {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                FileDocumentManager.getInstance().saveAllDocuments();
            }
        });
    }
}

