/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.vcs.log.Hash;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchUtil;
import git4idea.repo.GitRemote;

public class GitStandardRemoteBranch
extends GitRemoteBranch {
    private final GitRemote myRemote;
    private final String myNameAtRemote;

    public GitStandardRemoteBranch(GitRemote remote, String nameAtRemote, Hash hash) {
        super(GitStandardRemoteBranch.formStandardName(remote, GitBranchUtil.stripRefsPrefix(nameAtRemote)), hash);
        this.myRemote = remote;
        this.myNameAtRemote = GitBranchUtil.stripRefsPrefix(nameAtRemote);
    }

    private static String formStandardName(GitRemote remote, String nameAtRemote) {
        return remote.getName() + "/" + nameAtRemote;
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    @Override
    public GitRemote getRemote() {
        return this.myRemote;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GitStandardRemoteBranch branch = (GitStandardRemoteBranch)o;
        if (!this.myNameAtRemote.equals(branch.myNameAtRemote)) {
            return false;
        }
        return this.myRemote.equals(branch.myRemote);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myRemote.hashCode();
        result = 31 * result + this.myNameAtRemote.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public String getNameForRemoteOperations() {
        return this.myNameAtRemote;
    }

    @Override
    public String getNameForLocalOperations() {
        return this.myName;
    }
}

