/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionDvcsSpecific;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.util.GitFileUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;

public class GitFileRevision
extends VcsFileRevisionEx
implements Comparable<VcsFileRevision>,
VcsFileRevisionDvcsSpecific {
    private final Project myProject;
    private final FilePath myPath;
    private final GitRevisionNumber myRevision;
    private final Couple<Couple<String>> myAuthorAndCommitter;
    private final String myMessage;
    private final String myBranch;
    private final Date myAuthorTime;
    private final Collection<String> myParents;

    public GitFileRevision(Project project, FilePath path, GitRevisionNumber revision) {
        this(project, path, revision, null, null, null, null, Collections.emptyList());
    }

    public GitFileRevision(Project project, FilePath path, GitRevisionNumber revision, Couple<Couple<String>> authorAndCommitter, String message, String branch, Date authorTime, Collection<String> parents) {
        this.myProject = project;
        this.myPath = path;
        this.myRevision = revision;
        this.myAuthorAndCommitter = authorAndCommitter;
        this.myMessage = message;
        this.myBranch = branch;
        this.myAuthorTime = authorTime;
        this.myParents = parents;
    }

    public FilePath getPath() {
        return this.myPath;
    }

    public RepositoryLocation getChangedRepositoryPath() {
        return null;
    }

    public VcsRevisionNumber getRevisionNumber() {
        return this.myRevision;
    }

    public Date getRevisionDate() {
        return this.myRevision.getTimestamp();
    }

    public Date getDateForRevisionsOrdering() {
        return this.myAuthorTime;
    }

    public String getAuthor() {
        if (this.myAuthorAndCommitter != null) {
            return (String)((Couple)this.myAuthorAndCommitter.getFirst()).getFirst();
        }
        return null;
    }

    public String getAuthorEmail() {
        if (this.myAuthorAndCommitter != null) {
            return (String)((Couple)this.myAuthorAndCommitter.getFirst()).getSecond();
        }
        return null;
    }

    public String getCommitterName() {
        if (this.myAuthorAndCommitter != null) {
            return this.myAuthorAndCommitter.getSecond() == null ? null : (String)((Couple)this.myAuthorAndCommitter.getSecond()).getFirst();
        }
        return null;
    }

    public String getCommitterEmail() {
        if (this.myAuthorAndCommitter != null) {
            return this.myAuthorAndCommitter.getSecond() == null ? null : (String)((Couple)this.myAuthorAndCommitter.getSecond()).getSecond();
        }
        return null;
    }

    public String getCommitMessage() {
        return this.myMessage;
    }

    public String getBranchName() {
        return this.myBranch;
    }

    public synchronized byte[] loadContent() throws IOException, VcsException {
        VirtualFile root = GitUtil.getGitRoot(this.myPath);
        return GitFileUtils.getFileContent(this.myProject, root, this.myRevision.getRev(), VcsFileUtil.relativePath((VirtualFile)root, (FilePath)this.myPath));
    }

    public synchronized byte[] getContent() throws IOException, VcsException {
        return this.loadContent();
    }

    @Override
    public int compareTo(VcsFileRevision rev) {
        if (rev instanceof GitFileRevision) {
            return this.myRevision.compareTo((VcsRevisionNumber)((GitFileRevision)rev).myRevision);
        }
        return this.getRevisionDate().compareTo(rev.getRevisionDate());
    }

    public String toString() {
        return this.myPath.getName() + ":" + this.myRevision.getShortRev();
    }

    public Collection<String> getParents() {
        return this.myParents;
    }

    public String getHash() {
        return this.myRevision.getRev();
    }
}

