/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rpclib.schema;

import com.android.tools.rpclib.binary.BinaryClass;
import com.android.tools.rpclib.binary.BinaryObject;
import com.android.tools.rpclib.binary.Decoder;
import com.android.tools.rpclib.binary.Encoder;
import com.android.tools.rpclib.binary.Namespace;
import com.android.tools.rpclib.schema.Entity;
import com.android.tools.rpclib.schema.Type;
import com.android.tools.rpclib.schema.TypeTag;
import java.io.IOException;

public final class Struct
extends Type {
    Entity mEntity;

    public Struct(Entity entity) {
        this.mEntity = entity;
    }

    public Struct(Decoder d) throws IOException {
        this.mEntity = d.entity();
        d.nonCompactString();
    }

    public Entity getEntity() {
        return this.mEntity;
    }

    @Override
    public void encodeValue(Encoder e, Object value) throws IOException {
        assert (value instanceof BinaryObject);
        e.value((BinaryObject)value);
    }

    @Override
    public Object decodeValue(Decoder d) throws IOException {
        BinaryClass klass = Namespace.lookup(this.mEntity);
        if (klass == null) {
            throw new IOException("Unknown type: " + this.mEntity);
        }
        BinaryObject obj = klass.create();
        klass.decode(d, obj);
        return obj;
    }

    @Override
    public void encode(Encoder e) throws IOException {
        TypeTag.structTag().encode(e);
        e.entity(this.mEntity);
        e.nonCompactString("");
    }

    @Override
    void name(StringBuilder out) {
        out.append(this.mEntity.getName());
    }

    @Override
    public void signature(StringBuilder out) {
        out.append('$');
    }

    public boolean is(BinaryClass klass) {
        return this.mEntity.signature().equals(klass.entity().signature());
    }
}

