/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rpclib.schema;

import com.android.tools.rpclib.binary.Decoder;
import com.android.tools.rpclib.binary.Encoder;
import com.android.tools.rpclib.schema.Method;
import com.android.tools.rpclib.schema.Type;
import java.io.IOException;

public final class Primitive
extends Type {
    String mName;
    Method mMethod;

    public Primitive(String name, byte method) {
        this.mName = name;
        this.mMethod = new Method(method);
    }

    public Primitive(Decoder d, Method method) throws IOException {
        this.mMethod = method;
        this.mName = d.nonCompactString();
    }

    public String toString() {
        return this.mName + "(" + this.mMethod + ")";
    }

    public Method getMethod() {
        return this.mMethod;
    }

    @Override
    public void encodeValue(Encoder e, Object value) throws IOException {
        switch (this.mMethod.value) {
            case 0: {
                e.bool((Boolean)value);
                break;
            }
            case 1: {
                e.int8((Byte)value);
                break;
            }
            case 2: {
                e.uint8((Short)value);
                break;
            }
            case 3: {
                e.int16((Short)value);
                break;
            }
            case 4: {
                e.uint16((Integer)value);
                break;
            }
            case 5: {
                e.int32((Integer)value);
                break;
            }
            case 6: {
                e.uint32((Long)value);
                break;
            }
            case 7: {
                e.int64((Long)value);
                break;
            }
            case 8: {
                e.uint64((Long)value);
                break;
            }
            case 9: {
                e.float32(((Float)value).floatValue());
                break;
            }
            case 10: {
                e.float64((Double)value);
                break;
            }
            case 11: {
                e.string((String)value);
                break;
            }
            default: {
                throw new IOException("Invalid primitive method in encode");
            }
        }
    }

    @Override
    public Object decodeValue(Decoder d) throws IOException {
        switch (this.mMethod.value) {
            case 0: {
                return d.bool();
            }
            case 1: {
                return d.int8();
            }
            case 2: {
                return d.uint8();
            }
            case 3: {
                return d.int16();
            }
            case 4: {
                return d.uint16();
            }
            case 5: {
                return d.int32();
            }
            case 6: {
                return d.uint32();
            }
            case 7: {
                return d.int64();
            }
            case 8: {
                return d.uint64();
            }
            case 9: {
                return Float.valueOf(d.float32());
            }
            case 10: {
                return d.float64();
            }
            case 11: {
                return d.string();
            }
        }
        throw new IOException("Invalid primitive method in decode");
    }

    @Override
    public void encode(Encoder e) throws IOException {
        e.uint8((short)(0 | this.mMethod.value << 4));
        e.nonCompactString(this.mName);
    }

    @Override
    void name(StringBuilder out) {
        out.append(this.mName);
    }

    @Override
    public void signature(StringBuilder out) {
        out.append(this.mMethod);
    }
}

