/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rpclib.schema;

import com.android.tools.rpclib.binary.Decoder;
import com.android.tools.rpclib.binary.Encoder;
import com.android.tools.rpclib.schema.Type;
import com.android.tools.rpclib.schema.TypeTag;
import java.io.IOException;

public final class Array
extends Type {
    String mAlias;
    Type mValueType;
    int mSize;

    public Array(String alias, Type type, int size) {
        this.mAlias = alias;
        this.mValueType = type;
        this.mSize = size;
    }

    public Array(Decoder d) throws IOException {
        this.mSize = d.uint32();
        this.mValueType = Array.decode(d);
        this.mAlias = d.nonCompactString();
    }

    public String getAlias() {
        return this.mAlias;
    }

    public Type getValueType() {
        return this.mValueType;
    }

    public int getSize() {
        return this.mSize;
    }

    @Override
    public void encodeValue(Encoder e, Object value) throws IOException {
        assert (value instanceof Object[]);
        Object[] array = (Object[])value;
        for (int i = 0; i < this.mSize; ++i) {
            this.mValueType.encodeValue(e, array[i]);
        }
    }

    @Override
    public Object decodeValue(Decoder d) throws IOException {
        Object[] array = new Object[this.mSize];
        for (int i = 0; i < this.mSize; ++i) {
            array[i] = this.mValueType.decodeValue(d);
        }
        return array;
    }

    @Override
    public void encode(Encoder e) throws IOException {
        TypeTag.arrayTag().encode(e);
        e.uint32(this.mSize);
        this.mValueType.encode(e);
        e.nonCompactString(this.mAlias);
    }

    @Override
    void name(StringBuilder out) {
        out.append("array<");
        this.mValueType.name(out);
        out.append('>');
    }

    @Override
    public void signature(StringBuilder out) {
        out.append('[').append(this.mSize).append(']');
        this.mValueType.signature(out);
    }
}

