/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rpclib.multiplex;

import com.android.tools.rpclib.binary.Decoder;
import com.android.tools.rpclib.binary.Encoder;
import com.android.tools.rpclib.multiplex.Channel;
import com.android.tools.rpclib.multiplex.NewChannelListener;
import com.android.tools.rpclib.multiplex.Sender;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;

public class Multiplexer {
    private static final Logger LOG = Logger.getInstance(Multiplexer.class);
    private final Decoder mDecoder;
    private final Encoder mEncoder;
    private final NewChannelListener mNewChannelListener;
    private final Channel.EventHandler mChannelEventHandler;
    private final Sender mSender;
    private final AtomicLong mNextChannelId;
    private final Map<Long, Channel> mChannelMap;

    public Multiplexer(InputStream in, OutputStream out, int mtu, ExecutorService executorService, NewChannelListener newChannelListener) {
        this.mDecoder = new Decoder(in);
        this.mEncoder = new Encoder(out);
        this.mNewChannelListener = newChannelListener;
        this.mChannelEventHandler = new ChannelEventHandler();
        this.mSender = new Sender(mtu, executorService);
        this.mChannelMap = new HashMap<Long, Channel>();
        this.mNextChannelId = new AtomicLong(0L);
        executorService.execute(new Receiver());
    }

    public Channel openChannel() throws IOException {
        long id = this.mNextChannelId.getAndIncrement();
        Channel channel = this.newChannel(id);
        this.mSender.sendOpenChannel(id);
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Channel newChannel(long id) throws IOException {
        Long key = id;
        Channel channel = new Channel(id, this.mChannelEventHandler);
        Map<Long, Channel> map = this.mChannelMap;
        synchronized (map) {
            if (this.mChannelMap.isEmpty()) {
                this.mSender.begin(this.mEncoder);
            }
            this.mChannelMap.put(key, channel);
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteChannel(long id) {
        Long key = id;
        Map<Long, Channel> map = this.mChannelMap;
        synchronized (map) {
            if (this.mChannelMap.containsKey(key)) {
                this.mChannelMap.remove(key);
                if (this.mChannelMap.isEmpty()) {
                    this.mSender.end();
                }
            } else {
                LOG.info("Attempting to close unknown channel " + id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Channel getChannel(long id) {
        Channel channel;
        Long key = id;
        Map<Long, Channel> map = this.mChannelMap;
        synchronized (map) {
            channel = this.mChannelMap.get(key);
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAllChannels() {
        Map<Long, Channel> map = this.mChannelMap;
        synchronized (map) {
            for (Channel c : this.mChannelMap.values()) {
                try {
                    c.close();
                }
                catch (IOException ignored) {}
            }
            this.mChannelMap.clear();
        }
    }

    static /* synthetic */ Decoder access$300(Multiplexer x0) {
        return x0.mDecoder;
    }

    static /* synthetic */ Channel access$400(Multiplexer x0, long x1) throws IOException {
        return x0.newChannel(x1);
    }

    static /* synthetic */ NewChannelListener access$500(Multiplexer x0) {
        return x0.mNewChannelListener;
    }

    static /* synthetic */ Channel access$600(Multiplexer x0, long x1) {
        return x0.getChannel(x1);
    }

    static /* synthetic */ Logger access$700() {
        return LOG;
    }

    static /* synthetic */ void access$800(Multiplexer x0) {
        x0.closeAllChannels();
    }

    private class Receiver
    extends Thread {
        Receiver() {
            super("rpclib.multiplex Receiver");
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class ChannelEventHandler
    implements Channel.EventHandler {
        private ChannelEventHandler() {
        }

        @Override
        public void closeChannel(long id) throws IOException {
            Multiplexer.this.mSender.sendCloseChannel(id);
            Multiplexer.this.deleteChannel(id);
        }

        @Override
        public void writeChannel(long id, byte[] b, int off, int len) throws IOException {
            Multiplexer.this.mSender.sendData(id, b, off, len);
        }
    }
}

