/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.request;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.netbeans.lib.cvsclient.IClientEnvironment;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.admin.IAdminReader;
import org.netbeans.lib.cvsclient.command.KeywordSubstitution;
import org.netbeans.lib.cvsclient.file.AbstractFileObject;
import org.netbeans.lib.cvsclient.file.DirectoryObject;
import org.netbeans.lib.cvsclient.file.FileObject;
import org.netbeans.lib.cvsclient.file.ICvsFileSystem;
import org.netbeans.lib.cvsclient.request.AbstractRequest;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.ArgumentxRequest;
import org.netbeans.lib.cvsclient.request.DirectoryRequest;
import org.netbeans.lib.cvsclient.request.EntryRequest;
import org.netbeans.lib.cvsclient.request.IRequest;
import org.netbeans.lib.cvsclient.request.IsModifiedRequest;
import org.netbeans.lib.cvsclient.request.KoptRequest;
import org.netbeans.lib.cvsclient.request.ModifiedRequest;
import org.netbeans.lib.cvsclient.request.NotifyRequest;
import org.netbeans.lib.cvsclient.request.QuestionableRequest;
import org.netbeans.lib.cvsclient.request.ResponseExpectingRequest;
import org.netbeans.lib.cvsclient.request.StickyRequest;
import org.netbeans.lib.cvsclient.request.UnchangedRequest;
import org.netbeans.lib.cvsclient.util.BugLog;

public final class Requests {
    private final List requestList = new ArrayList();
    private final ICvsFileSystem cvsFileSystem;
    private final IAdminReader adminReader;
    private final ResponseExpectingRequest responseExpectingRequest;

    public Requests(ResponseExpectingRequest responseExpectingRequest, IClientEnvironment clientEnvironment) {
        BugLog.getInstance().assertNotNull(responseExpectingRequest);
        BugLog.getInstance().assertNotNull(clientEnvironment);
        this.responseExpectingRequest = responseExpectingRequest;
        this.cvsFileSystem = clientEnvironment.getCvsFileSystem();
        this.adminReader = clientEnvironment.getAdminReader();
    }

    public void addRequest(IRequest request) {
        BugLog.getInstance().assertNotNull(request);
        this.requestList.add(request);
    }

    public void addArgumentRequest(String argument) {
        this.addRequest(new ArgumentRequest(argument));
    }

    public void addArgumentRequest(Object obj, String argument) {
        if (obj == null) {
            return;
        }
        String objString = obj.toString().trim();
        if (objString.length() == 0) {
            return;
        }
        this.addArgumentRequest(argument);
        this.addArgumentRequest(objString);
    }

    public void addArgumentRequests(Object obj, String argument) {
        if (obj == null) {
            return;
        }
        String objString = obj.toString().trim();
        if (objString.length() == 0) {
            return;
        }
        this.addArgumentRequest(argument);
        this.addArgumentRequest(objString);
    }

    public void addArgumentRequest(boolean value, String argument) {
        if (value) {
            this.addArgumentRequest(argument);
        }
    }

    public void addLocalPathDirectoryRequest() {
        this.addDirectoryRequest(DirectoryObject.getRoot());
    }

    public String addDirectoryRequest(DirectoryObject directoryObject) {
        String relativeDirPath = directoryObject.toUnixPath();
        String repositoryPath = this.cvsFileSystem.getRepositoryForDirectory(directoryObject, this.adminReader);
        this.addRequest(new DirectoryRequest(relativeDirPath, repositoryPath));
        if (this.adminReader.isStatic(directoryObject, this.cvsFileSystem)) {
            this.addRequest(new AbstractRequest(){

                @Override
                public String getRequestString() {
                    return "Static-directory \n";
                }
            });
        }
        return repositoryPath;
    }

    public void addFileArgumentRequest(AbstractFileObject fileObject) {
        this.addArgumentRequest(fileObject.toUnixPath());
    }

    public void addMessageRequests(String message) {
        this.addArgumentRequest("-m");
        boolean first = true;
        StringTokenizer token = new StringTokenizer(message, "\n", false);
        while (token.hasMoreTokens()) {
            if (first) {
                this.addArgumentRequest(token.nextToken());
                first = false;
                continue;
            }
            this.addRequest(new ArgumentxRequest(token.nextToken()));
        }
    }

    public List getRequests() {
        return Collections.unmodifiableList(this.requestList);
    }

    public ResponseExpectingRequest getResponseExpectingRequest() {
        return this.responseExpectingRequest;
    }

    public void addDirectoryStickyRequests(DirectoryObject directoryObject, IAdminReader adminReader, ICvsFileSystem cvsFileSystem) {
        this.addDirectoryRequest(directoryObject);
        this.addStickyRequest(adminReader.getStickyTagForDirectory(directoryObject, cvsFileSystem));
    }

    public void addStickyRequest(String tag) {
        if (tag != null) {
            this.addRequest(new StickyRequest(tag));
        }
    }

    public void addModifiedRequest(FileObject fileObject, boolean binary, boolean writable) {
        this.addRequest(new ModifiedRequest(fileObject, binary, writable));
    }

    public void addIsModifiedRequest(FileObject fileObject) {
        this.addRequest(new IsModifiedRequest(fileObject));
    }

    public void addUnchangedRequest(FileObject fileObject) {
        this.addRequest(new UnchangedRequest(fileObject));
    }

    public void addEntryRequest(Entry entry) {
        this.addRequest(new EntryRequest(entry));
    }

    public void addQuestionableRequest(FileObject fileObject) {
        this.addRequest(new QuestionableRequest(fileObject));
    }

    public void addNotifyRequest(FileObject fileObject, String command, String temporaryWatch) {
        String path = this.cvsFileSystem.getLocalFileSystem().getFile(fileObject.getParent()).getAbsolutePath();
        this.addRequest(new NotifyRequest(fileObject, path, command, temporaryWatch));
    }

    public void addKoptRequest(KeywordSubstitution keywordSubstMode) {
        this.addRequest(new KoptRequest(keywordSubstMode));
    }
}

