/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.netbeans.lib.cvsclient.util.BugLog;

public abstract class AbstractInputStreamReader
extends Reader {
    private InputStream inputStream;

    protected abstract int readChar(InputStream var1) throws IOException;

    protected AbstractInputStreamReader(InputStream inputStream) {
        BugLog.getInstance().assertNotNull(inputStream);
        this.inputStream = inputStream;
    }

    @Override
    public final int read() throws IOException {
        this.ensureOpen();
        return this.readChar(this.inputStream);
    }

    @Override
    public final int read(char[] buffer, int startOffset, int length) throws IOException {
        int value;
        if (startOffset < 0 || startOffset > buffer.length || length < 0 || startOffset + length > buffer.length || startOffset + length < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureOpen();
        int charsRead = 0;
        int offset = startOffset;
        while (length > 0 && (value = this.readChar(this.inputStream)) >= 0) {
            buffer[offset] = (char)value;
            ++offset;
            ++charsRead;
            --length;
        }
        return charsRead > 0 ? charsRead : -1;
    }

    @Override
    public final boolean ready() throws IOException {
        this.ensureOpen();
        try {
            return this.inputStream.available() > 0;
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    public final void close() throws IOException {
        if (this.inputStream == null) {
            return;
        }
        this.inputStream.close();
        this.inputStream = null;
    }

    private void ensureOpen() throws IOException {
        if (this.inputStream == null) {
            throw new IOException("Stream closed");
        }
    }
}

