/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.event;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.event.ICvsListenerRegistry;
import org.netbeans.lib.cvsclient.event.IDirectoryListener;
import org.netbeans.lib.cvsclient.event.IEntryListener;
import org.netbeans.lib.cvsclient.event.IEventSender;
import org.netbeans.lib.cvsclient.event.IFileInfoListener;
import org.netbeans.lib.cvsclient.event.IMessageListener;
import org.netbeans.lib.cvsclient.event.IModuleExpansionListener;
import org.netbeans.lib.cvsclient.event.ITerminationListener;
import org.netbeans.lib.cvsclient.file.DirectoryObject;
import org.netbeans.lib.cvsclient.file.FileObject;

public final class EventManager
implements IEventSender,
ICvsListenerRegistry {
    private final List terminationListeners = new ArrayList();
    private final List messageListener = new ArrayList();
    private final List moduleExpansionListeners = new ArrayList();
    private final List fileInfoListeners = new ArrayList();
    private final List entryListeners = new ArrayList();
    private final List directoryListeners = new ArrayList();
    private final String myCharset;

    public EventManager(String charset) {
        this.myCharset = charset;
    }

    @Override
    public synchronized void addTerminationListener(ITerminationListener listener) {
        this.terminationListeners.add(listener);
    }

    @Override
    public synchronized void removeTerminationListener(ITerminationListener listener) {
        this.terminationListeners.remove(listener);
    }

    @Override
    public synchronized void addMessageListener(IMessageListener listener) {
        this.messageListener.add(listener);
    }

    @Override
    public synchronized void removeMessageListener(IMessageListener listener) {
        this.messageListener.remove(listener);
    }

    @Override
    public synchronized void addModuleExpansionListener(IModuleExpansionListener listener) {
        this.moduleExpansionListeners.add(listener);
    }

    @Override
    public synchronized void removeModuleExpansionListener(IModuleExpansionListener listener) {
        this.moduleExpansionListeners.remove(listener);
    }

    @Override
    public void addEntryListener(IEntryListener listener) {
        this.entryListeners.add(listener);
    }

    @Override
    public void removeEntryListener(IEntryListener listener) {
        this.entryListeners.remove(listener);
    }

    @Override
    public synchronized void addFileInfoListener(IFileInfoListener listener) {
        this.fileInfoListeners.add(listener);
    }

    @Override
    public synchronized void removeFileInfoListener(IFileInfoListener listener) {
        this.fileInfoListeners.remove(listener);
    }

    @Override
    public synchronized void addDirectoryListener(IDirectoryListener listener) {
        this.directoryListeners.add(listener);
    }

    @Override
    public synchronized void removeDirectoryListener(IDirectoryListener listener) {
        this.directoryListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyTerminationListeners(boolean error) {
        ITerminationListener[] copiedListeners;
        EventManager eventManager = this;
        synchronized (eventManager) {
            if (this.terminationListeners.size() == 0) {
                return;
            }
            copiedListeners = new ITerminationListener[this.terminationListeners.size()];
            this.terminationListeners.toArray(copiedListeners);
        }
        for (int i = 0; i < copiedListeners.length; ++i) {
            copiedListeners[i].commandTerminated(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyMessageListeners(byte[] message, boolean error, boolean tagged) {
        IMessageListener[] copiedListeners;
        EventManager eventManager = this;
        synchronized (eventManager) {
            if (this.messageListener.size() == 0) {
                return;
            }
            copiedListeners = new IMessageListener[this.messageListener.size()];
            this.messageListener.toArray(copiedListeners);
        }
        try {
            String stringMessage = new String(message, this.myCharset);
            for (int i = 0; i < copiedListeners.length; ++i) {
                copiedListeners[i].messageSent(stringMessage, message, error, tagged);
            }
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyModuleExpansionListeners(String module) {
        IModuleExpansionListener[] copiedListeners;
        EventManager eventManager = this;
        synchronized (eventManager) {
            if (this.moduleExpansionListeners.size() == 0) {
                return;
            }
            copiedListeners = new IModuleExpansionListener[this.moduleExpansionListeners.size()];
            this.moduleExpansionListeners.toArray(copiedListeners);
        }
        for (int i = 0; i < copiedListeners.length; ++i) {
            copiedListeners[i].moduleExpanded(module);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyFileInfoListeners(Object fileInfoContainer) {
        IFileInfoListener[] copiedListeners;
        EventManager eventManager = this;
        synchronized (eventManager) {
            if (this.fileInfoListeners.size() == 0) {
                return;
            }
            copiedListeners = new IFileInfoListener[this.fileInfoListeners.size()];
            this.fileInfoListeners.toArray(copiedListeners);
        }
        for (int i = 0; i < copiedListeners.length; ++i) {
            copiedListeners[i].fileInfoGenerated(fileInfoContainer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyFileInfoListeners(byte[] bytes) {
        IMessageListener[] copiedListeners;
        EventManager eventManager = this;
        synchronized (eventManager) {
            if (this.messageListener.size() == 0) {
                return;
            }
            copiedListeners = new IMessageListener[this.messageListener.size()];
            this.messageListener.toArray(copiedListeners);
        }
        for (int i = 0; i < copiedListeners.length; ++i) {
            copiedListeners[i].binaryMessageSent(bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyEntryListeners(FileObject fileObject, Entry entry) {
        IEntryListener[] copiedListeners;
        EventManager eventManager = this;
        synchronized (eventManager) {
            if (this.entryListeners.size() == 0) {
                return;
            }
            copiedListeners = new IEntryListener[this.entryListeners.size()];
            this.entryListeners.toArray(copiedListeners);
        }
        for (int i = 0; i < copiedListeners.length; ++i) {
            copiedListeners[i].gotEntry(fileObject, entry);
        }
    }

    @Override
    public void notifyDirectoryListeners(DirectoryObject directoryObject, boolean setStatic) {
        for (IDirectoryListener directoryListener : this.directoryListeners) {
            directoryListener.processingDirectory(directoryObject);
        }
    }
}

