/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.reservedcheckout;

import com.intellij.util.text.SyncDateFormat;
import java.io.File;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.AbstractMessageParser;
import org.netbeans.lib.cvsclient.command.ICvsFiles;
import org.netbeans.lib.cvsclient.command.ICvsFilesVisitor;
import org.netbeans.lib.cvsclient.command.reservedcheckout.EditorsFileInfoContainer;
import org.netbeans.lib.cvsclient.command.reservedcheckout.TabStringTokenizer;
import org.netbeans.lib.cvsclient.event.IEventSender;
import org.netbeans.lib.cvsclient.file.DirectoryObject;
import org.netbeans.lib.cvsclient.file.FileObject;
import org.netbeans.lib.cvsclient.file.ICvsFileSystem;

final class EditorsMessageParser
extends AbstractMessageParser {
    private static final String DATE_FORMAT_STR = "MMM dd hh:mm:ss yyyy";
    private static final SyncDateFormat DATE_FORMAT = new SyncDateFormat((DateFormat)new SimpleDateFormat("MMM dd hh:mm:ss yyyy", Locale.US));
    private final IEventSender eventManager;
    private final ICvsFileSystem cvsFileSystem;
    private final Set fileSet = new HashSet();
    private transient EditorsFileInfoContainer editorsFileInfo;

    public EditorsMessageParser(IEventSender eventManager, final ICvsFileSystem cvsFileSystem, ICvsFiles cvsFiles) {
        this.eventManager = eventManager;
        this.cvsFileSystem = cvsFileSystem;
        cvsFiles.visit(new ICvsFilesVisitor(){

            @Override
            public void handleFile(FileObject fileObject, Entry entry, boolean exists) {
                File file = cvsFileSystem.getLocalFileSystem().getFile(fileObject);
                EditorsMessageParser.this.fileSet.add(file);
            }

            @Override
            public void handleDirectory(DirectoryObject directoryObject) {
            }
        });
    }

    @Override
    public void parseLine(String line, boolean isErrorMessage) {
        if (isErrorMessage) {
            return;
        }
        TabStringTokenizer tokenizer = new TabStringTokenizer(line);
        String fileName = tokenizer.nextToken();
        String user = tokenizer.nextToken();
        String dateString = tokenizer.nextToken();
        String clientName = tokenizer.nextToken();
        String editDirectory = tokenizer.nextToken();
        if (editDirectory == null) {
            return;
        }
        if (fileName.length() > 0) {
            File file = this.cvsFileSystem.getLocalFileSystem().getFile(fileName);
            if (this.editorsFileInfo != null && !this.editorsFileInfo.getFile().equals(file)) {
                this.fireFileInfoEvent(this.editorsFileInfo, true);
                this.editorsFileInfo = null;
            }
            if (this.editorsFileInfo == null) {
                this.editorsFileInfo = new EditorsFileInfoContainer(file);
            }
        } else if (this.editorsFileInfo == null) {
            return;
        }
        try {
            Date date = EditorsMessageParser.parseDate(dateString);
            this.editorsFileInfo.addEditor(date, user, clientName, editDirectory);
        }
        catch (ParseException ex) {
            return;
        }
    }

    @Override
    public void outputDone() {
        if (this.editorsFileInfo != null) {
            this.fireFileInfoEvent(this.editorsFileInfo, true);
            this.editorsFileInfo = null;
        }
        Iterator it = this.fileSet.iterator();
        while (it.hasNext()) {
            File file = (File)it.next();
            this.fireFileInfoEvent(new EditorsFileInfoContainer(file), false);
            it.remove();
        }
    }

    private void fireFileInfoEvent(EditorsFileInfoContainer editorsFileInfo, boolean remove) {
        this.eventManager.notifyFileInfoListeners(editorsFileInfo);
        if (remove) {
            this.fileSet.remove(editorsFileInfo.getFile());
        }
    }

    private static Date parseDate(String dateString) throws ParseException {
        int firstSpaceIndex = Math.max(dateString.indexOf(32), 0);
        int lastSpaceIndex = Math.min(dateString.lastIndexOf(32), dateString.length());
        dateString = dateString.substring(firstSpaceIndex, lastSpaceIndex).trim();
        return DATE_FORMAT.parse(dateString);
    }

    @Override
    public void binaryMessageSent(byte[] bytes) {
    }
}

