/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.commit;

import java.io.IOException;
import java.util.Date;
import org.netbeans.lib.cvsclient.IClientEnvironment;
import org.netbeans.lib.cvsclient.IRequestProcessor;
import org.netbeans.lib.cvsclient.command.AbstractCommand;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.CommandUtils;
import org.netbeans.lib.cvsclient.command.ICvsFiles;
import org.netbeans.lib.cvsclient.command.IOCommandException;
import org.netbeans.lib.cvsclient.command.commit.CommitParser;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.DualListener;
import org.netbeans.lib.cvsclient.event.ICvsListenerRegistry;
import org.netbeans.lib.cvsclient.event.IEventSender;
import org.netbeans.lib.cvsclient.file.FileObject;
import org.netbeans.lib.cvsclient.progress.IProgressViewer;
import org.netbeans.lib.cvsclient.progress.RangeProgressViewer;
import org.netbeans.lib.cvsclient.progress.receiving.FileInfoAndMessageResponseProgressHandler;
import org.netbeans.lib.cvsclient.progress.sending.FileStateRequestsProgressHandler;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.Requests;

public final class CommitCommand
extends AbstractCommand {
    public static final String EXAM_DIR = "server: Examining ";
    private String message;
    private boolean forceCommit;
    private boolean noModuleProgram;
    private String toRevisionOrBranch;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(IRequestProcessor requestProcessor, IEventSender eventSender, ICvsListenerRegistry listenerRegistry, IClientEnvironment clientEnvironment, IProgressViewer progressViewer) throws CommandException, AuthenticationException {
        ICvsFiles cvsFiles;
        try {
            cvsFiles = this.scanFileSystem(clientEnvironment);
        }
        catch (IOException ex) {
            throw new IOCommandException(ex);
        }
        Requests requests = new Requests(CommandRequest.COMMIT, clientEnvironment);
        requests.addArgumentRequest(this.isForceCommit(), "-f");
        requests.addArgumentRequest(this.isRecursive(), "-R");
        requests.addArgumentRequest(this.isNoModuleProgram(), "-n");
        requests.addArgumentRequest(this.getToRevisionOrBranch(), "-r");
        this.addFileRequests(cvsFiles, requests, clientEnvironment);
        requests.addMessageRequests(CommandUtils.getMessageNotNull(this.getMessage()));
        requests.addLocalPathDirectoryRequest();
        this.addArgumentRequests(requests);
        FileStateRequestsProgressHandler requestsProgressHandler = new FileStateRequestsProgressHandler(new RangeProgressViewer(progressViewer, 0.0, 0.5), cvsFiles);
        FileInfoAndMessageResponseProgressHandler responseProgressHandler = new FileInfoAndMessageResponseProgressHandler(new RangeProgressViewer(progressViewer, 0.5, 1.0), cvsFiles, EXAM_DIR);
        CommitParser commitParser = new CommitParser(eventSender, clientEnvironment.getCvsFileSystem());
        DualListener parser = new DualListener(commitParser, responseProgressHandler);
        parser.registerListeners(listenerRegistry);
        try {
            boolean bl = requestProcessor.processRequests(requests, requestsProgressHandler);
            return bl;
        }
        finally {
            parser.unregisterListeners(listenerRegistry);
        }
    }

    @Override
    protected boolean isModified(FileObject fileObject, Date entryLastModified, IClientEnvironment clientEnvironment) {
        if (this.isForceCommit()) {
            return true;
        }
        return super.isModified(fileObject, entryLastModified, clientEnvironment);
    }

    @Override
    public String getCvsCommandLine() {
        StringBuffer cvsCommandLine = new StringBuffer("commit ");
        cvsCommandLine.append(this.getCvsArguments());
        this.appendFileArguments(cvsCommandLine);
        return cvsCommandLine.toString();
    }

    @Override
    public void resetCvsCommand() {
        super.resetCvsCommand();
        this.setMessage(null);
        this.setRecursive(true);
        this.setForceCommit(false);
        this.setNoModuleProgram(false);
        this.setToRevisionOrBranch(null);
    }

    private String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    private boolean isForceCommit() {
        return this.forceCommit;
    }

    public void setForceCommit(boolean forceCommit) {
        this.forceCommit = forceCommit;
    }

    private boolean isNoModuleProgram() {
        return this.noModuleProgram;
    }

    public void setNoModuleProgram(boolean noModuleProgram) {
        this.noModuleProgram = noModuleProgram;
    }

    private String getToRevisionOrBranch() {
        return this.toRevisionOrBranch;
    }

    public void setToRevisionOrBranch(String toRevisionOrBranch) {
        this.toRevisionOrBranch = toRevisionOrBranch;
    }

    private String getCvsArguments() {
        StringBuilder arguments = new StringBuilder();
        if (!this.isRecursive()) {
            arguments.append("-l ");
        }
        if (this.isForceCommit()) {
            arguments.append("-f ");
            if (this.isRecursive()) {
                arguments.append("-R ");
            }
        }
        if (this.isNoModuleProgram()) {
            arguments.append("-n ");
        }
        if (this.getToRevisionOrBranch() != null) {
            arguments.append("-r ");
            arguments.append(this.getToRevisionOrBranch());
            arguments.append(" ");
        }
        if (this.getMessage() != null) {
            arguments.append("-m \"");
            arguments.append(CommandUtils.getMessageNotNull(this.getMessage()));
            arguments.append("\" ");
        }
        return arguments.toString();
    }
}

