/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.TestNGException;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.BaseTestMethod;
import org.testng.internal.NoOpTestClass;
import org.testng.internal.Parameters;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class FactoryMethod
extends BaseTestMethod {
    private static final long serialVersionUID = -7329918821346197099L;
    private Object m_instance = null;
    private XmlTest m_xmlTest = null;
    private ITestContext m_testContext = null;

    public FactoryMethod(Method method, Object instance, XmlTest xmlTest, IAnnotationFinder annotationFinder, ITestContext testContext) {
        super(method, annotationFinder);
        if (!method.getDeclaringClass().isAssignableFrom(instance.getClass())) {
            throw new TestNGException("Mismatch between instance/method classes:" + instance.getClass() + " " + method.getDeclaringClass());
        }
        this.m_instance = instance;
        this.m_xmlTest = xmlTest;
        this.m_testContext = testContext;
        NoOpTestClass tc = new NoOpTestClass();
        tc.setTestClass(method.getDeclaringClass());
        this.m_testClass = tc;
    }

    private static void ppp(String s) {
        System.out.println("[FactoryMethod] " + s);
    }

    public Object[] invoke() {
        List result = Lists.newArrayList();
        Map<String, String> allParameterNames = Maps.newHashMap();
        Iterator<Object[]> parameterIterator = Parameters.handleParameters((ITestNGMethod)this, allParameterNames, (Object)this.m_instance, (Parameters.MethodParameters)new Parameters.MethodParameters(this.m_xmlTest.getParameters(), null, null, (ITestContext)this.m_testContext, null), (XmlSuite)this.m_xmlTest.getSuite(), (IAnnotationFinder)this.m_annotationFinder, null).parameters;
        try {
            while (parameterIterator.hasNext()) {
                Object[] testInstances;
                Object[] parameters = parameterIterator.next();
                for (Object testInstance : testInstances = (Object[])this.getMethod().invoke(this.m_instance, parameters)) {
                    result.add(testInstance);
                }
            }
        }
        catch (Throwable t) {
            throw new TestNGException("The factory method " + this.getMethod().getDeclaringClass() + "." + this.getMethod().getName() + "() threw an exception", t);
        }
        return result.toArray(new Object[result.size()]);
    }

    public ITestNGMethod clone() {
        throw new IllegalStateException("clone is not supported for FactoryMethod");
    }
}

