/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.embedder;

import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.DefaultArtifactResolver;
import org.jetbrains.idea.maven.model.MavenWorkspaceMap;
import org.jetbrains.idea.maven.server.embedder.Maven2ModelConverter;
import org.jetbrains.idea.maven.server.embedder.UnresolvedArtifactsCollector;

public class CustomArtifactResolver
extends DefaultArtifactResolver {
    private MavenWorkspaceMap myWorkspaceMap;
    private UnresolvedArtifactsCollector myUnresolvedCollector;

    public void customize(MavenWorkspaceMap workspaceMap, boolean failOnUnresolved) {
        this.myWorkspaceMap = workspaceMap;
        this.myUnresolvedCollector = new UnresolvedArtifactsCollector(failOnUnresolved);
    }

    public void reset() {
        this.myWorkspaceMap = null;
        this.myUnresolvedCollector = null;
    }

    public UnresolvedArtifactsCollector getUnresolvedCollector() {
        return this.myUnresolvedCollector;
    }

    public void resolve(Artifact artifact, List remoteRepositories, ArtifactRepository localRepository) throws ArtifactResolutionException, ArtifactNotFoundException {
        if (this.resolveAsModule(artifact)) {
            return;
        }
        try {
            super.resolve(artifact, remoteRepositories, localRepository);
        }
        catch (AbstractArtifactResolutionException e) {
            this.myUnresolvedCollector.collectAndSetResolved(artifact);
        }
    }

    public void resolveAlways(Artifact artifact, List remoteRepositories, ArtifactRepository localRepository) throws ArtifactResolutionException, ArtifactNotFoundException {
        if (this.resolveAsModule(artifact)) {
            return;
        }
        try {
            super.resolveAlways(artifact, remoteRepositories, localRepository);
        }
        catch (AbstractArtifactResolutionException e) {
            this.myUnresolvedCollector.collectAndSetResolved(artifact);
        }
    }

    private boolean resolveAsModule(Artifact a) {
        MavenWorkspaceMap map = this.myWorkspaceMap;
        if (map == null) {
            return false;
        }
        MavenWorkspaceMap.Data resolved = map.findFileAndOriginalId(Maven2ModelConverter.createMavenId(a));
        if (resolved == null) {
            return false;
        }
        a.setResolved(true);
        a.setFile(resolved.getFile(a.getType()));
        a.selectVersion(resolved.originalId.getVersion());
        return true;
    }
}

