/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeResolver;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelType<T> {
    public static final ModelType<Object> UNTYPED = ModelType.of(Object.class);
    private final TypeToken<T> typeToken;

    private ModelType(TypeToken<T> typeToken) {
        this.typeToken = typeToken;
    }

    protected ModelType() {
        this.typeToken = new TypeToken<T>(this.getClass()){};
    }

    protected ModelType(Class<?> clazz) {
        this(new TypeToken<T>(clazz){});
    }

    public static <T> ModelType<T> of(Class<T> clazz) {
        return new Simple(TypeToken.of(clazz));
    }

    public static <T> ModelType<T> typeOf(T instance) {
        Class<?> clazz = instance.getClass();
        return ModelType.of(clazz);
    }

    public static ModelType<?> of(Type type) {
        return ModelType.toModelType(TypeToken.of((Type)type));
    }

    private static <T> ModelType<T> toModelType(TypeToken<T> type) {
        return new Simple(type);
    }

    public Class<? super T> getRawClass() {
        return this.typeToken.getRawType();
    }

    public Class<T> getConcreteClass() {
        Class<T> concreteClass = this.getRawClass();
        return concreteClass;
    }

    public boolean isParameterized() {
        return this.typeToken.getType() instanceof ParameterizedType;
    }

    public List<ModelType<?>> getTypeVariables() {
        if (this.isParameterized()) {
            List<Type> types = Arrays.asList(((ParameterizedType)this.typeToken.getType()).getActualTypeArguments());
            return ImmutableList.builder().addAll(Iterables.transform(types, (Function)new Function<Type, ModelType<?>>(){

                public ModelType<?> apply(Type input) {
                    return ModelType.of(input);
                }
            })).build();
        }
        return Collections.emptyList();
    }

    public ModelType<? extends T> asSubclass(ModelType<?> modelType) {
        Class<?> otherClass;
        boolean isSubclass;
        if (this.isWildcard() || modelType.isWildcard()) {
            return null;
        }
        Class<T> thisClass = this.getRawClass();
        boolean bl = isSubclass = thisClass.isAssignableFrom(otherClass = modelType.getRawClass()) && !thisClass.equals(otherClass);
        if (isSubclass) {
            ModelType<?> cast = modelType;
            return cast;
        }
        return null;
    }

    public boolean isAssignableFrom(ModelType<?> modelType) {
        return this.typeToken.isAssignableFrom(modelType.typeToken);
    }

    public boolean isWildcard() {
        return this.getWildcardType() != null;
    }

    public ModelType<?> getUpperBound() {
        WildcardType wildcardType = this.getWildcardType();
        if (wildcardType == null) {
            return null;
        }
        ModelType<?> upperBoundType = ModelType.of(wildcardType.getUpperBounds()[0]);
        if (upperBoundType.equals(UNTYPED)) {
            return null;
        }
        return upperBoundType;
    }

    public ModelType<?> getLowerBound() {
        WildcardType wildcardType = this.getWildcardType();
        if (wildcardType == null) {
            return null;
        }
        Type[] lowerBounds = wildcardType.getLowerBounds();
        if (lowerBounds.length == 0) {
            return null;
        }
        return ModelType.of(lowerBounds[0]);
    }

    private WildcardType getWildcardType() {
        Type type = this.typeToken.getType();
        if (type instanceof WildcardType) {
            return (WildcardType)type;
        }
        return null;
    }

    public String toString() {
        return this.typeToken.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModelType)) {
            return false;
        }
        ModelType modelType = (ModelType)o;
        return this.typeToken.equals(modelType.typeToken);
    }

    public int hashCode() {
        return this.typeToken.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Parameter<T> {
        private final TypeVariable<?> typeVariable;

        public Parameter() {
            Type type = new TypeToken<T>(this.getClass()){}.getType();
            if (!(type instanceof TypeVariable)) {
                throw new IllegalStateException("T for Parameter<T> MUST be a type variable");
            }
            this.typeVariable = (TypeVariable)type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Builder<T> {
        private TypeToken<T> typeToken = new TypeToken<T>(this.getClass()){};

        public <I> Builder<T> where(Parameter<I> parameter, ModelType<I> type) {
            TypeResolver resolver = new TypeResolver().where((Type)((Parameter)parameter).typeVariable, ((ModelType)type).typeToken.getType());
            this.typeToken = TypeToken.of((Type)resolver.resolveType(this.typeToken.getType()));
            return this;
        }

        public ModelType<T> build() {
            return new Simple(this.typeToken);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Simple<T>
    extends ModelType<T> {
        private Simple(TypeToken<T> typeToken) {
            super(typeToken);
        }
    }
}

