/*
 * Decompiled with CFR 0.152.
 */
package org.java.ayatana;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.java.ayatana.AyatanaLibrary;
import org.java.ayatana.DefaultExtraMenuAction;
import org.java.ayatana.ExtraMenuAction;
import org.java.ayatana.GMainLoop;

public final class ApplicationMenu
implements WindowListener,
AWTEventListener,
ContainerListener,
ComponentListener,
PropertyChangeListener {
    private static final List<Window> windows = new ArrayList<Window>();
    private static boolean initialized = false;
    private Window window;
    private JMenuBar menubar;
    private boolean tryInstalled = false;
    private ExtraMenuAction extraMenuAction;
    private long windowxid = -1L;
    private boolean allowDynamicMenuBar;
    private long approveRebuild = -1L;

    public static JMenuBar getWindowMenuBar(Window window) {
        if (window instanceof JFrame) {
            return ((JFrame)window).getJMenuBar();
        }
        if (window instanceof JDialog) {
            return ((JDialog)window).getJMenuBar();
        }
        return null;
    }

    public static String getWindowTitle(Window window) {
        if (window instanceof JFrame) {
            return ((JFrame)window).getTitle();
        }
        if (window instanceof JDialog) {
            return ((JDialog)window).getTitle();
        }
        return null;
    }

    public static JRootPane getWindowRootPane(Window window) {
        if (window instanceof JFrame) {
            return ((JFrame)window).getRootPane();
        }
        if (window instanceof JDialog) {
            return ((JDialog)window).getRootPane();
        }
        return null;
    }

    public static boolean tryInstall(Window window) {
        return ApplicationMenu.tryInstall(window, ApplicationMenu.getWindowMenuBar(window), new DefaultExtraMenuAction());
    }

    public static boolean tryInstall(Window window, JMenuBar menubar) {
        return ApplicationMenu.tryInstall(window, ApplicationMenu.getWindowMenuBar(window), new DefaultExtraMenuAction());
    }

    public static boolean tryInstall(Window window, ExtraMenuAction additionalMenuAction) {
        return ApplicationMenu.tryInstall(window, ApplicationMenu.getWindowMenuBar(window), additionalMenuAction);
    }

    public static boolean tryInstall(Window window, JMenuBar menubar, ExtraMenuAction additionalMenuAction) {
        if (window == null || additionalMenuAction == null) {
            throw new NullPointerException();
        }
        if (menubar == null) {
            return false;
        }
        if (windows.contains(window)) {
            return false;
        }
        String menuProxy = System.getenv("UBUNTU_MENUPROXY");
        if (!"libappmenu.so".equals(menuProxy) && !"1".equals(menuProxy)) {
            return false;
        }
        if (AyatanaLibrary.load()) {
            new ApplicationMenu(window, menubar, additionalMenuAction);
            return true;
        }
        return false;
    }

    private static native void nativeInitialize();

    private static native void nativeUninitialize();

    private static synchronized void initialize() {
        if (!initialized) {
            GMainLoop.run();
            ApplicationMenu.nativeInitialize();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ApplicationMenu.nativeUninitialize();
                        }
                    });
                }
            });
            initialized = true;
        }
    }

    private native void setCurrent(long var1);

    private native long getWindowXID(Window var1);

    private native void registerWatcher(long var1);

    private native void unregisterWatcher(long var1);

    private void addMenu(JMenu menu) {
        if (menu.getText() == null || "".equals(menu.getText())) {
            return;
        }
        this.addMenu(menu.hashCode(), menu.getText(), menu.isEnabled());
    }

    private native void addMenu(int var1, String var2, boolean var3);

    private synchronized void removeAllMenus() {
        this.removeAll();
    }

    private native void removeAll();

    private void addMenuItem(JMenuItem menuitem) {
        if (menuitem.getText() == null || "".equals(menuitem.getText())) {
            return;
        }
        int modifiers = -1;
        int keycode = -1;
        if (menuitem.getAccelerator() != null) {
            modifiers = menuitem.getAccelerator().getModifiers();
            keycode = menuitem.getAccelerator().getKeyCode();
        }
        if (menuitem instanceof JMenu) {
            this.addMenu((JMenu)menuitem);
        } else if (menuitem instanceof JRadioButtonMenuItem) {
            this.addMenuItemRadio(menuitem.hashCode(), menuitem.getText(), menuitem.isEnabled(), modifiers, keycode, menuitem.isSelected());
        } else if (menuitem instanceof JCheckBoxMenuItem) {
            this.addMenuItemCheck(menuitem.hashCode(), menuitem.getText(), menuitem.isEnabled(), modifiers, keycode, menuitem.isSelected());
        } else {
            this.addMenuItem(menuitem.hashCode(), menuitem.getText(), menuitem.isEnabled(), modifiers, keycode);
        }
    }

    private native void addMenuItem(int var1, String var2, boolean var3, int var4, int var5);

    private native void addMenuItemRadio(int var1, String var2, boolean var3, int var4, int var5, boolean var6);

    private native void addMenuItemCheck(int var1, String var2, boolean var3, int var4, int var5, boolean var6);

    private void addSeparator() {
        this.addMenuItemSeparator();
    }

    private native void addMenuItemSeparator();

    private ApplicationMenu(Window window, JMenuBar menubar, ExtraMenuAction additionalMenuAction) {
        windows.add(window);
        this.window = window;
        this.menubar = menubar;
        this.extraMenuAction = additionalMenuAction;
        this.allowDynamicMenuBar = this.extraMenuAction.allowDynamicMenuBar();
        window.addWindowListener(this);
        if (window.isDisplayable()) {
            this.tryInstall();
        }
    }

    private synchronized void tryInstall() {
        if (this.tryInstalled && this.windowxid > -1L) {
            this.setCurrent(this.windowxid);
        } else if (!this.tryInstalled) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ApplicationMenu.initialize();
                    ApplicationMenu.this.windowxid = ApplicationMenu.this.getWindowXID(ApplicationMenu.this.window);
                    ApplicationMenu.this.registerWatcher(ApplicationMenu.this.windowxid);
                }
            });
            this.tryInstalled = true;
        }
    }

    private synchronized void tryUninstall() {
        if (this.tryInstalled) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ApplicationMenu.this.unregisterWatcher(ApplicationMenu.this.windowxid);
                    ApplicationMenu.this.window.removeWindowListener(ApplicationMenu.this);
                    windows.remove(ApplicationMenu.this.window);
                }
            });
            this.tryInstalled = false;
        }
    }

    private synchronized void buildMenuBar() {
        this.buildMenuBar(false);
    }

    private synchronized void buildMenuBar(boolean first) {
        for (Component comp : this.menubar.getComponents()) {
            if (!(comp instanceof JMenu)) continue;
            if (comp.isVisible()) {
                this.addMenu((JMenu)comp);
            }
            if (!first || !this.allowDynamicMenuBar) continue;
            ((JMenu)comp).addComponentListener(this);
            ((JMenu)comp).addPropertyChangeListener(this);
        }
    }

    private synchronized void install() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Toolkit.getDefaultToolkit().addAWTEventListener(ApplicationMenu.this, 8L);
                ApplicationMenu.this.buildMenuBar(true);
                if (ApplicationMenu.this.allowDynamicMenuBar) {
                    ApplicationMenu.this.menubar.addContainerListener(ApplicationMenu.this);
                }
                ApplicationMenu.this.menubar.setVisible(false);
            }
        });
    }

    private synchronized void uninstall() {
        if (this.allowDynamicMenuBar) {
            for (Component comp : this.menubar.getComponents()) {
                if (!(comp instanceof JMenu)) continue;
                ((JMenu)comp).removeComponentListener(this);
                ((JMenu)comp).removePropertyChangeListener(this);
            }
            this.menubar.removeContainerListener(this);
        }
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        this.menubar.setVisible(true);
    }

    private JMenuItem getJMenuItem(int hashcode) {
        for (Component comp : this.menubar.getComponents()) {
            JMenuItem item;
            if (!(comp instanceof JMenuItem) || (item = this.getJMenuItem((JMenuItem)comp, hashcode)) == null) continue;
            return item;
        }
        return null;
    }

    private JMenuItem getJMenuItem(JMenuItem menu, int hashcode) {
        if (menu.hashCode() == hashcode) {
            return menu;
        }
        if (menu instanceof JMenu) {
            for (Component comp : ((JMenu)menu).getMenuComponents()) {
                JMenuItem item;
                if (!(comp instanceof JMenuItem) || (item = this.getJMenuItem((JMenuItem)comp, hashcode)) == null) continue;
                return item;
            }
        }
        return null;
    }

    private JMenuItem getJMenuItem(int keycode, int modifiers) {
        for (Component comp : this.menubar.getComponents()) {
            JMenuItem item;
            if (!(comp instanceof JMenuItem) || (item = this.getJMenuItem((JMenuItem)comp, keycode, modifiers)) == null) continue;
            return item;
        }
        return null;
    }

    private JMenuItem getJMenuItem(JMenuItem menu, int keycode, int modifiers) {
        if (menu instanceof JMenu) {
            for (Component comp : ((JMenu)menu).getMenuComponents()) {
                JMenuItem item;
                if (!(comp instanceof JMenuItem) || (item = this.getJMenuItem((JMenuItem)comp, keycode, modifiers)) == null) continue;
                return item;
            }
        } else {
            if (menu.getAccelerator() == null) {
                return null;
            }
            if (menu.getAccelerator().getKeyCode() == keycode && menu.getAccelerator().getModifiers() == modifiers) {
                return menu;
            }
        }
        return null;
    }

    private void itemActivated(final int hashcode) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ApplicationMenu.this.invokeMenuItem(ApplicationMenu.this.getJMenuItem(hashcode), false);
                }
            });
        }
        catch (InterruptedException ex) {
            Logger.getLogger(ApplicationMenu.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(ApplicationMenu.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void itemAboutToShow(final int hashcode) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ApplicationMenu.this.invokeSelectMenu((JMenu)ApplicationMenu.this.getJMenuItem(hashcode));
                }
            });
        }
        catch (InterruptedException ex) {
            Logger.getLogger(ApplicationMenu.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(ApplicationMenu.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void itemAfterShow(final int hashcode) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ApplicationMenu.this.invokeDeselectMenu((JMenu)ApplicationMenu.this.getJMenuItem(hashcode));
                }
            });
        }
        catch (InterruptedException ex) {
            Logger.getLogger(ApplicationMenu.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(ApplicationMenu.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void invokeMenuItem(JMenuItem menuitem, boolean shortcut) {
        if (menuitem != null && menuitem.isEnabled() && menuitem.isVisible() && this.extraMenuAction.allowMenuAction(this.window, this.menubar, menuitem, true, shortcut)) {
            menuitem.getModel().setArmed(true);
            menuitem.getModel().setPressed(true);
            this.extraMenuAction.invokeMenu(this.window, this.menubar, menuitem, true, shortcut);
            menuitem.getModel().setPressed(false);
            menuitem.getModel().setArmed(false);
        }
    }

    private void invokeSelectMenu(JMenu menu) {
        if (menu != null && menu.isEnabled() && menu.isVisible() && this.extraMenuAction.allowMenuAction(this.window, this.menubar, menu, true, false)) {
            this.extraMenuAction.beforInvokeMenu(this.window, this.menubar, menu, true, false);
            menu.getModel().setSelected(true);
            JPopupMenu popupMenu = menu.getPopupMenu();
            PopupMenuEvent pevent = new PopupMenuEvent(popupMenu);
            for (PopupMenuListener pl : menu.getPopupMenu().getPopupMenuListeners()) {
                if (pl == null) continue;
                pl.popupMenuWillBecomeVisible(pevent);
            }
            this.extraMenuAction.invokeMenu(this.window, this.menubar, menu, true, false);
            for (Component comp : popupMenu.getComponents()) {
                if (!comp.isVisible()) continue;
                if (comp instanceof JMenu) {
                    this.addMenu((JMenu)comp);
                    continue;
                }
                if (comp instanceof JMenuItem) {
                    this.addMenuItem((JMenuItem)comp);
                    continue;
                }
                if (!(comp instanceof JSeparator)) continue;
                this.addSeparator();
            }
            this.extraMenuAction.afterInvokeMenu(this.window, this.menubar, menu, true, false);
        }
    }

    private void invokeDeselectMenu(JMenu menu) {
        if (menu != null && menu.isEnabled() && menu.isVisible() && this.extraMenuAction.allowMenuAction(this.window, this.menubar, menu, false, false)) {
            this.extraMenuAction.beforInvokeMenu(this.window, this.menubar, menu, false, false);
            this.extraMenuAction.invokeMenu(this.window, this.menubar, menu, false, false);
            PopupMenuEvent pevent = new PopupMenuEvent(menu.getPopupMenu());
            for (PopupMenuListener pl : menu.getPopupMenu().getPopupMenuListeners()) {
                if (pl == null) continue;
                pl.popupMenuWillBecomeInvisible(pevent);
            }
            menu.getModel().setSelected(false);
            this.extraMenuAction.afterInvokeMenu(this.window, this.menubar, menu, false, false);
        }
    }

    private void invokeAccelerator(int keycode, int modifiers) {
        this.invokeMenuItem(this.getJMenuItem(keycode, modifiers), true);
    }

    private Window getWindow(Component comp) {
        if (comp == null) {
            return null;
        }
        if (comp instanceof JFrame) {
            return (Window)comp;
        }
        if (comp instanceof JDialog) {
            return (Window)comp;
        }
        return this.getWindow(comp.getParent());
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        Window currwindow;
        KeyEvent e;
        if (event.getID() == 402 && (e = (KeyEvent)event).getKeyCode() != 18 && e.getKeyCode() != 16 && e.getKeyCode() != 17 && e.getKeyCode() != 157 && e.getKeyCode() != 65406 && this.window.isActive() && this.window.equals(currwindow = event.getSource() instanceof Component ? this.getWindow((Component)event.getSource()) : (event.getSource() instanceof JFrame ? (Window)event.getSource() : (event.getSource() instanceof JDialog ? (Window)event.getSource() : null)))) {
            this.invokeAccelerator(e.getKeyCode(), e.getModifiersEx() | e.getModifiers());
        }
    }

    private void rebuildMenuBar() {
        if (this.approveRebuild == -1L) {
            this.approveRebuild = System.currentTimeMillis() + 500L;
            new Thread(){

                @Override
                public void run() {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                ApplicationMenu.this.removeAllMenus();
                                ApplicationMenu.this.buildMenuBar();
                                ApplicationMenu.this.approveRebuild = -1L;
                            }
                        });
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(ApplicationMenu.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (InvocationTargetException ex) {
                        Logger.getLogger(ApplicationMenu.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }.start();
        } else {
            this.approveRebuild = System.currentTimeMillis() + 500L;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("Wrong thread");
        }
        if ("enabled".equals(evt.getPropertyName()) && evt.getSource() instanceof JMenu) {
            this.rebuildMenuBar();
        }
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("Wrong thread");
        }
        if (e.getChild() instanceof JMenu) {
            ((JMenu)e.getChild()).addComponentListener(this);
            ((JMenu)e.getChild()).addPropertyChangeListener(this);
            this.rebuildMenuBar();
        }
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("Wrong thread");
        }
        if (e.getChild() instanceof JMenu) {
            ((JMenu)e.getChild()).removeComponentListener(this);
            ((JMenu)e.getChild()).removePropertyChangeListener(this);
            this.rebuildMenuBar();
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("Wrong thread");
        }
        if (e.getSource() instanceof JMenu) {
            this.rebuildMenuBar();
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("Wrong thread");
        }
        if (e.getSource() instanceof JMenu) {
            this.rebuildMenuBar();
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
        this.tryInstall();
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.tryUninstall();
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
        this.tryInstall();
    }
}

