/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.maven.model.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.ModuleBasedBuildTargetType;
import org.jetbrains.jps.maven.model.JpsMavenExtensionService;
import org.jetbrains.jps.maven.model.impl.MavenResourcesTarget;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;

public class MavenResourcesTargetType
extends ModuleBasedBuildTargetType<MavenResourcesTarget> {
    public static final MavenResourcesTargetType PRODUCTION = new MavenResourcesTargetType("maven-resources-production", false);
    public static final MavenResourcesTargetType TEST = new MavenResourcesTargetType("maven-resources-test", true);
    private final boolean myIsTests;

    private MavenResourcesTargetType(String typeId, boolean isTests) {
        super(typeId);
        this.myIsTests = isTests;
    }

    public boolean isTests() {
        return this.myIsTests;
    }

    public List<MavenResourcesTarget> computeAllTargets(JpsModel model) {
        ArrayList<MavenResourcesTarget> targets = new ArrayList<MavenResourcesTarget>();
        JpsMavenExtensionService service = JpsMavenExtensionService.getInstance();
        for (JpsModule module : model.getProject().getModules()) {
            if (service.getExtension(module) == null) continue;
            targets.add(new MavenResourcesTarget(this, module));
        }
        return targets;
    }

    public BuildTargetLoader<MavenResourcesTarget> createLoader(JpsModel model) {
        final HashMap<String, JpsModule> modules = new HashMap<String, JpsModule>();
        for (JpsModule module : model.getProject().getModules()) {
            modules.put(module.getName(), module);
        }
        return new BuildTargetLoader<MavenResourcesTarget>(){

            public MavenResourcesTarget createTarget(String targetId) {
                JpsModule module = (JpsModule)modules.get(targetId);
                return module != null ? new MavenResourcesTarget(MavenResourcesTargetType.this, module) : null;
            }
        };
    }
}

