/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.maven.compiler;

import java.io.File;
import java.io.FileFilter;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactRootCopyingHandlerProvider;
import org.jetbrains.jps.incremental.artifacts.instructions.FileCopyingHandler;
import org.jetbrains.jps.incremental.artifacts.instructions.FilterCopyHandler;
import org.jetbrains.jps.maven.model.JpsMavenExtensionService;
import org.jetbrains.jps.maven.model.impl.MavenEjbClientConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenProjectConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenResourceFileFilter;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElement;

public class MavenEjbArtifactRootCopyingHandlerProvider
extends ArtifactRootCopyingHandlerProvider {
    public FileCopyingHandler createCustomHandler(JpsArtifact artifact, File root, JpsPackagingElement contextElement, JpsModel model, BuildDataPaths buildDataPaths) {
        MavenProjectConfiguration projectConfiguration = JpsMavenExtensionService.getInstance().getMavenProjectConfiguration(buildDataPaths);
        if (projectConfiguration == null) {
            return null;
        }
        MavenEjbClientConfiguration ejbCfg = projectConfiguration.ejbClientArtifactConfigs.get(artifact.getName());
        if (ejbCfg == null) {
            return null;
        }
        return new FilterCopyHandler((FileFilter)new MavenResourceFileFilter(root, ejbCfg));
    }
}

