/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.ddmlib.IDevice;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.editors.navigation.NavigationEditorUtils;
import com.android.tools.idea.run.AndroidRunningState;
import com.android.tools.ndk.ModulePathManager;
import com.android.tools.ndk.run.AndroidNativeDebugProcess;
import com.android.tools.ndk.run.crash.AndroidLLDBBreakpadIntegration;
import com.android.tools.ndk.run.lldb.AndroidLLDBDriverConfiguration;
import com.android.tools.ndk.run.lldb.JavaCallSignature;
import com.google.common.collect.Lists;
import com.google.protobuf.GeneratedMessage;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.util.Consumer;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBEntityNotValidException;
import com.jetbrains.cidr.execution.debugger.backend.lldb.ProtobufMessageFactory;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.Model;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.Protocol;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.android.facet.IdeaSourceProvider;

public class AndroidLLDBDriver
extends LLDBDriver {
    private static final String PLATFORM_NAME = "remote-android";
    private static final String ENV_VAR_PREFIX = "ANDROIDSTUDIO_LLDB_EXTRA_CMD_";
    private static final String[] STARTUP_SCRIPTS = new String[]{ModulePathManager.getLLDBSharedBinFile("init_script").getPath(), ModulePathManager.getLLDBStlPrintersBinFile("load_script").getPath()};
    private static final int CONNECT_PLATFORM_NUM_RETRIES = 10;
    private static final int CONNECT_PLATFORM_TIMEOUT_MSECS = 500;
    private final AndroidRunningState myState;
    private final List<File> mySymDirs;
    private final String myDeviceSN;
    private final String myPlatformDomainSocketPath;
    private final String[] myStartupCommands;
    private boolean myCrashed = false;
    private static final Logger LOG = Logger.getInstance(AndroidLLDBDriver.class);

    public AndroidLLDBDriver(DebuggerDriver.Handler handler, AndroidLLDBDriverConfiguration configuration) {
        super(handler, (DebuggerDriverConfiguration)configuration);
        this.myState = configuration.getState();
        IDevice device = configuration.getDevice();
        this.myDeviceSN = device.getSerialNumber();
        this.myPlatformDomainSocketPath = configuration.getPlatformDomainSocketPath();
        this.myStartupCommands = configuration.getStartupCommands();
        ArrayList abis = Lists.newArrayListWithExpectedSize((int)device.getAbis().size());
        for (String abiStr : device.getAbis()) {
            Abi abi = Abi.getEnum((String)abiStr);
            if (abi != null) {
                abis.add(abi);
                continue;
            }
            LOG.error("Failed to find ABI by name " + abiStr);
        }
        this.mySymDirs = AndroidNativeDebugProcess.getSymbolsDir(this.myState, abis);
        if (this.mySymDirs.isEmpty()) {
            LOG.warn("No symbol directories found");
            this.myState.getPrinter().stderr("Attention! No symbol directories found - please check your native debug configuration");
        }
    }

    public void loadForRemote(File deviceSupport) throws ExecutionException {
        LOG.debug("Load startup scripts");
        this.loadStartupScripts();
        LOG.debug("run console commands from environment");
        this.runEnvCommands();
        this.runStartupCommands();
        LOG.debug("createEmptyTarget");
        this.createEmptyTarget();
        LOG.debug("connectPlatform");
        LLDBEntityNotValidException lastException = null;
        for (int i = 0; i < 10; ++i) {
            try {
                this.connectPlatform();
                lastException = null;
                break;
            }
            catch (LLDBEntityNotValidException e) {
                lastException = e;
                LOG.warn("failed to connect platform - retrying");
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
                continue;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        if (!this.mySymDirs.isEmpty()) {
            ArrayList searchPaths = Lists.newArrayListWithExpectedSize((int)this.mySymDirs.size());
            for (File symDir : this.mySymDirs) {
                searchPaths.add("\"" + symDir.getAbsolutePath() + "\"");
            }
            String searchPathsStr = StringUtil.join((Collection)searchPaths, (String)" ");
            LOG.info("Set target.exec-search-paths: " + searchPathsStr);
            this.executeConsoleCommand("settings set target.exec-search-paths " + searchPathsStr);
        }
    }

    private void runStartupCommands() throws ExecutionException {
        if (this.myStartupCommands == null) {
            return;
        }
        for (String cmd : this.myStartupCommands) {
            LOG.info("Startup command: " + cmd);
            this.executeConsoleCommand(cmd);
        }
    }

    public boolean supportsWatchpoints() {
        return false;
    }

    private void runEnvCommands() throws ExecutionException {
        String envCommand;
        int i = 0;
        while ((envCommand = System.getenv(ENV_VAR_PREFIX + i)) != null) {
            LOG.info("Environment command: " + envCommand);
            this.executeConsoleCommand(envCommand);
            ++i;
        }
    }

    private void loadStartupScripts() throws ExecutionException {
        for (String script : STARTUP_SCRIPTS) {
            LOG.info("Loading startup script: " + script);
            this.executeConsoleCommand("command source \"" + script + "\"");
        }
    }

    private void createEmptyTarget() throws ExecutionException {
        LLDBDriver.ThrowIfNotValid responseHandler = new LLDBDriver.ThrowIfNotValid("Couldn't create target");
        Protocol.CompositeRequest createTargetReq = ProtobufMessageFactory.createTarget((String)"", (String)"");
        this.getProtobufClient().sendMessageAndWaitForReply((GeneratedMessage)createTargetReq, Protocol.CreateTarget_Res.class, (Consumer)responseHandler);
        responseHandler.throwIfNeeded();
    }

    private void connectPlatform() throws ExecutionException {
        String connectURL = String.format("adb://[%s]%s", this.myDeviceSN, this.myPlatformDomainSocketPath);
        LOG.info("Connecting to LLDB server: " + connectURL);
        LLDBDriver.ThrowIfNotValid responseHandler = new LLDBDriver.ThrowIfNotValid("Couldn't connect platform");
        Protocol.CompositeRequest connectPlatformReq = ProtobufMessageFactory.connectPlatform((String)PLATFORM_NAME, (String)connectURL);
        this.getProtobufClient().sendMessageAndWaitForReply((GeneratedMessage)connectPlatformReq, Protocol.ConnectPlatform_Res.class, (Consumer)responseHandler);
        responseHandler.throwIfNeeded();
    }

    public void start(Installer installer, String architecture, boolean isRemote) throws ExecutionException {
        super.start(installer, architecture, isRemote);
        AndroidLLDBBreakpadIntegration.monitorForCrashes(this);
    }

    protected void handleDriverException(Exception e) {
        if (!AndroidLLDBBreakpadIntegration.checkForCrashes(this)) {
            super.handleDriverException(e);
        }
    }

    protected File getSourceFile(final Model.LLDBFrame frame) {
        String sourceFile = frame.getFile();
        File sf = new File(frame.getFile());
        if (sf.isAbsolute()) {
            return sf;
        }
        IdeaSourceProvider srcProvider = this.myState.getFacet().getMainIdeaSourceProvider();
        for (Collection srcDirs : Lists.newArrayList((Object[])new Collection[]{srcProvider.getJavaDirectories(), srcProvider.getJniDirectories()})) {
            File foundSrcFile = AndroidLLDBDriver.findSourceFile(srcDirs, sourceFile);
            if (foundSrcFile == null) continue;
            return foundSrcFile;
        }
        String psiMethodFilePath = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                PsiMethod psiMethod = AndroidLLDBDriver.this.parseJavaCallSignature(frame.getFunction());
                if (psiMethod == null) {
                    return null;
                }
                try {
                    VirtualFile srcFile = psiMethod.getContainingFile().getVirtualFile();
                    if (srcFile != null) {
                        return srcFile.getCanonicalPath();
                    }
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
                return null;
            }
        });
        if (psiMethodFilePath != null) {
            return new File(psiMethodFilePath);
        }
        return sf;
    }

    private static File findSourceFile(Collection<VirtualFile> srcDirs, String relPath) {
        for (VirtualFile srcDir : srcDirs) {
            VirtualFile childFile = srcDir.findFileByRelativePath(relPath);
            if (childFile == null) continue;
            return new File(childFile.getCanonicalPath());
        }
        return null;
    }

    protected LLFrame newLLFrame(final Model.LLDBFrame frame) {
        Pair location;
        int line;
        String sourceFile = frame.getFile();
        if (sourceFile != null && !sourceFile.isEmpty()) {
            try {
                sourceFile = this.getSourceFile(frame).getCanonicalPath();
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        if ((line = frame.getLine() - 1) < 0 && sourceFile != null && (location = (Pair)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Pair<String, Integer>>(){

            public Pair<String, Integer> compute() {
                PsiMethod psiMethod = AndroidLLDBDriver.this.parseJavaCallSignature(frame.getFunction());
                if (psiMethod == null) {
                    return null;
                }
                try {
                    VirtualFile srcFile = psiMethod.getContainingFile().getVirtualFile();
                    if (srcFile == null) {
                        return null;
                    }
                    Document document = FileDocumentManager.getInstance().getDocument(srcFile);
                    if (document == null) {
                        return null;
                    }
                    return Pair.create((Object)srcFile.getCanonicalPath(), (Object)document.getLineNumber(psiMethod.getTextOffset()));
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                    return null;
                }
            }
        })) != null) {
            sourceFile = (String)location.getFirst();
            line = (Integer)location.getSecond();
        }
        return new LLFrame(frame.getNumber(), frame.getFunction(), sourceFile, line, frame.getPc());
    }

    private PsiMethod parseJavaCallSignature(String callSignature) {
        JavaCallSignature signature = JavaCallSignature.Parse(callSignature);
        if (signature == null) {
            return null;
        }
        PsiClass psiClass = NavigationEditorUtils.getPsiClass((Module)this.myState.getFacet().getModule(), (String)signature.getClassName());
        if (psiClass == null) {
            return null;
        }
        for (PsiMethod psiMethod : psiClass.findMethodsByName(signature.getMethodName(), true)) {
            PsiParameterList paramList;
            if (!psiMethod.getReturnType().equalsToText(signature.getReturnType()) || (paramList = psiMethod.getParameterList()).getParametersCount() != signature.getParameterList().size()) continue;
            PsiParameter[] psiParams = paramList.getParameters();
            boolean equalParameterTypes = true;
            for (int i = 0; i < psiParams.length && equalParameterTypes; ++i) {
                equalParameterTypes = psiParams[i].getType().equalsToText(signature.getParameterList().get(i));
            }
            if (!equalParameterTypes) continue;
            return psiMethod;
        }
        return null;
    }

    public boolean isCrashed() {
        return this.myCrashed;
    }

    public void setCrashed(boolean crashed) {
        this.myCrashed = crashed;
    }
}

