/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.hybrid;

import com.android.tools.ndk.jni.JniNameMangler;
import com.android.tools.ndk.run.hybrid.MethodCollector;
import com.android.tools.ndk.run.hybrid.NativeDebugProcess;
import com.android.tools.ndk.run.hybrid.StepIntoNativeBreakpointType;
import com.google.common.collect.Lists;
import com.intellij.debugger.engine.BasicStepMethodFilter;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiMethod;
import com.intellij.util.Range;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionAdapter;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import com.intellij.xdebugger.stepping.XSmartStepIntoVariant;
import com.sun.jdi.Location;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Future;
import javax.swing.Icon;

public class AndroidJavaDebugProcess
extends JavaDebugProcess {
    private static final Logger LOG = Logger.getInstance(AndroidJavaDebugProcess.class);
    private static final String TID_EXPRESSION = "android.os.Process.myTid()";
    private final DebuggerSession myJavaSession;
    private final Project myProject;
    private final NativeDebugProcess myNativeDebugProcess;
    private final XSmartStepIntoHandler<?> mySmartStepIntoHandler = new SmartStepIntoHandlerImpl();
    private XSourcePosition myPauseSourcePosition;
    private Future<Integer> myCurrentTidFuture;

    public static JavaDebugProcess create(XDebugSession session, DebuggerSession javaSession, NativeDebugProcess nativeDebugProcess) {
        AndroidJavaDebugProcess res = new AndroidJavaDebugProcess(session, javaSession, nativeDebugProcess);
        javaSession.getProcess().setXDebugProcess((JavaDebugProcess)res);
        return res;
    }

    protected AndroidJavaDebugProcess(XDebugSession session, DebuggerSession javaSession, NativeDebugProcess nativeDebugProcess) {
        super(session, javaSession);
        this.myJavaSession = javaSession;
        this.myNativeDebugProcess = nativeDebugProcess;
        this.myProject = javaSession.getProject();
        session.addSessionListener((XDebugSessionListener)new XDebugSessionAdapter(){

            public void sessionPaused() {
                AndroidJavaDebugProcess.this.updateSourcePosition();
            }

            public void stackFrameChanged() {
                AndroidJavaDebugProcess.this.updateSourcePosition();
            }
        });
    }

    private Future<Integer> getCurrentThreadIdFuture(XSourcePosition sourcePosition) {
        final FutureResult futureResult = new FutureResult();
        XDebuggerEvaluator.XEvaluationCallback evaluationCallback = new XDebuggerEvaluator.XEvaluationCallback(){

            public void evaluated(XValue result) {
                if (result instanceof JavaValue) {
                    JavaValue jValue = (JavaValue)result;
                    futureResult.set((Object)Integer.parseInt(jValue.getDescriptor().getValue().toString()));
                } else {
                    futureResult.setException((Throwable)new EvaluateException("Unexpected value type: " + result.toString()));
                }
            }

            public void errorOccurred(String errorMessage) {
                futureResult.setException((Throwable)new EvaluateException("Evaluation failed: " + errorMessage));
            }
        };
        this.getEvaluator().evaluate(TID_EXPRESSION, evaluationCallback, sourcePosition);
        return futureResult;
    }

    void updateSourcePosition() {
        XStackFrame frame;
        if (this.myCurrentTidFuture != null) {
            this.myCurrentTidFuture.cancel(true);
            this.myCurrentTidFuture = null;
        }
        if ((frame = this.getSession().getCurrentStackFrame()) != null) {
            this.myPauseSourcePosition = frame.getSourcePosition();
            this.myCurrentTidFuture = this.getCurrentThreadIdFuture(this.myPauseSourcePosition);
        } else {
            this.myPauseSourcePosition = null;
        }
    }

    private void setupNativeBreakpoints(int tid) {
        final LinkedList jniMethodNames = Lists.newLinkedList();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                jniMethodNames.addAll(AndroidJavaDebugProcess.this.findNativeMethodsInCurrentSourcePosition());
            }
        });
        for (String jniMethodName : jniMethodNames) {
            this.myNativeDebugProcess.registerStepIntoNativeBreakpoint(jniMethodName, tid);
        }
    }

    private List<PsiMethod> findMethodsBySourcePosition(XSourcePosition position) {
        MethodCollector methodCollector = new MethodCollector(this.myProject, position);
        return methodCollector.getMethods();
    }

    private List<String> findNativeMethodsInCurrentSourcePosition() {
        List<PsiMethod> methods = this.findMethodsBySourcePosition(this.myPauseSourcePosition);
        LinkedList jniMethodNames = Lists.newLinkedList();
        for (PsiMethod method : methods) {
            if (!AndroidJavaDebugProcess.isNativeMethod(method)) continue;
            jniMethodNames.add(AndroidJavaDebugProcess.formatJniMethodPattern(method));
        }
        return jniMethodNames;
    }

    private static boolean isNativeMethod(PsiMethod method) {
        return method.getModifierList().hasExplicitModifier("native");
    }

    private static String formatJniMethodPattern(PsiMethod method) {
        StringBuilder sb = new StringBuilder();
        sb.append("Java_");
        sb.append(".*");
        sb.append(JniNameMangler.jniEncodeUnderscore(method.getName(), false));
        sb.append(".*");
        return sb.toString();
    }

    private void initNativeSteppingInto() {
        if (this.myPauseSourcePosition == null || this.myCurrentTidFuture == null) {
            return;
        }
        try {
            int currentTid = this.myCurrentTidFuture.get();
            this.setupNativeBreakpoints(currentTid);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private void removeAllStepIntoNativeMethodBreakpoints() {
        this.myNativeDebugProcess.removeAllStepIntoNativeBreakpoints();
    }

    public void startStepInto() {
        this.initNativeSteppingInto();
        super.startStepInto();
    }

    public void startForceStepInto() {
        this.initNativeSteppingInto();
        super.startForceStepInto();
    }

    public void startStepOver() {
        this.removeAllStepIntoNativeMethodBreakpoints();
        super.startStepOver();
    }

    public void runToPosition(XSourcePosition position) {
        this.removeAllStepIntoNativeMethodBreakpoints();
        super.runToPosition(position);
    }

    public void resume() {
        this.removeAllStepIntoNativeMethodBreakpoints();
        super.resume();
    }

    public void stop() {
        super.stop();
        this.myNativeDebugProcess.getSession().stop();
    }

    public XSmartStepIntoHandler<?> getSmartStepIntoHandler() {
        return this.mySmartStepIntoHandler;
    }

    private class SmartStepIntoHandlerImpl
    extends XSmartStepIntoHandler<XSmartStepIntoVariantImpl> {
        private SmartStepIntoHandlerImpl() {
        }

        public List<XSmartStepIntoVariantImpl> computeSmartStepVariants(XSourcePosition position) {
            MethodCollector methodCollector = new MethodCollector(AndroidJavaDebugProcess.this.myProject, position);
            List<PsiMethod> methods = methodCollector.getMethods();
            ArrayList variants = Lists.newArrayListWithExpectedSize((int)methods.size());
            Range<Integer> lineRange = methodCollector.getLineRange();
            if (lineRange != null) {
                for (PsiMethod method : methods) {
                    variants.add(new XSmartStepIntoVariantImpl(method, lineRange));
                }
            }
            return variants;
        }

        public void startStepInto(XSmartStepIntoVariantImpl variant) {
            PsiMethod method = variant.getMethod();
            if (!AndroidJavaDebugProcess.isNativeMethod(method)) {
                AndroidJavaDebugProcess.this.myJavaSession.stepInto(true, (MethodFilter)new BasicStepMethodFilter(method, variant.getLineRange()));
                return;
            }
            try {
                XBreakpoint<StepIntoNativeBreakpointType.Properties> bp = AndroidJavaDebugProcess.this.myNativeDebugProcess.registerStepIntoNativeBreakpoint(AndroidJavaDebugProcess.formatJniMethodPattern(method), (Integer)AndroidJavaDebugProcess.this.myCurrentTidFuture.get());
                AndroidJavaDebugProcess.this.myJavaSession.stepInto(true, (MethodFilter)new NativeMethodFilter(bp, variant.getLineRange()));
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }

        public String getPopupTitle(XSourcePosition position) {
            return "Method to Step Into";
        }
    }

    private class XSmartStepIntoVariantImpl
    extends XSmartStepIntoVariant {
        private final PsiMethod myMethod;
        private final Range<Integer> myLineRange;

        public XSmartStepIntoVariantImpl(PsiMethod method, Range<Integer> lineRange) {
            this.myMethod = method;
            this.myLineRange = lineRange;
        }

        public Icon getIcon() {
            return this.myMethod.getIcon(2);
        }

        public String getText() {
            return this.myMethod.getText();
        }

        public Range<Integer> getLineRange() {
            return this.myLineRange;
        }

        public PsiMethod getMethod() {
            return this.myMethod;
        }
    }

    private static class NativeMethodFilter
    implements MethodFilter {
        private final XBreakpoint<StepIntoNativeBreakpointType.Properties> myBp;
        private final Range<Integer> myLineRange;

        public NativeMethodFilter(XBreakpoint<StepIntoNativeBreakpointType.Properties> bp, Range<Integer> lineRange) {
            this.myBp = bp;
            this.myLineRange = lineRange;
        }

        public boolean locationMatches(DebugProcessImpl process, Location location) throws EvaluateException {
            return ((StepIntoNativeBreakpointType.Properties)this.myBp.getProperties()).isCalled();
        }

        public Range<Integer> getCallingExpressionLines() {
            return this.myLineRange;
        }
    }
}

