/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.editors;

import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.ndk.GradleWorkspace;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.jetbrains.cidr.lang.OCFileType;

public class NewCppSourceNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"android.ndk.editors.newCppSource");
    private final Project myProject;

    public NewCppSourceNotificationProvider(Project project) {
        this.myProject = project;
    }

    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    public EditorNotificationPanel createNotificationPanel(VirtualFile file, FileEditor fileEditor) {
        if (file.getFileType() != OCFileType.INSTANCE) {
            return null;
        }
        GradleWorkspace workspace = GradleWorkspace.getInstance(this.myProject);
        if (!workspace.isInProject(file) && workspace.isInProjectDirectories(file)) {
            return new StaleCppProjectNotificationPanel("This file has been added after the last project sync with Gradle. Please sync the project again for the NDK support to work properly.");
        }
        return null;
    }

    private class StaleCppProjectNotificationPanel
    extends EditorNotificationPanel {
        StaleCppProjectNotificationPanel(String message) {
            this.setText(message);
            this.createActionLabel("Sync Now", new Runnable(){

                @Override
                public void run() {
                    GradleProjectImporter.getInstance().requestProjectSync(NewCppSourceNotificationProvider.this.myProject, null);
                }
            });
        }
    }
}

