/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.NativeLibrary;
import com.android.builder.model.NativeToolchain;
import com.android.builder.model.Variant;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.messages.Message;
import com.android.tools.idea.gradle.messages.ProjectSyncMessages;
import com.android.tools.idea.gradle.project.AndroidGradleNotification;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.gradle.service.notification.errors.NdkLocationNotFoundErrorHandler;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.run.TargetSelectionMode;
import com.android.tools.idea.sdk.SdkPaths;
import com.android.tools.idea.stats.UsageTracker;
import com.android.tools.ndk.ModuleResolveConfiguration;
import com.android.tools.ndk.NdkCompilerInfoCache;
import com.android.tools.ndk.run.AndroidNativeRunConfiguration;
import com.android.tools.ndk.run.AndroidNativeRunConfigurationType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiFileSystemItem;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.parser.OCParserDefinition;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackers;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeaderRoots;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;

public class GradleWorkspace
extends AbstractProjectComponent
implements OCWorkspace {
    private static final Logger LOG = Logger.getInstance(GradleWorkspace.class);
    private final NdkCompilerInfoCache myCompilerInfoCache = new NdkCompilerInfoCache();
    private final OCWorkspaceModificationTrackers myTrackers;
    private Set<VirtualFile> myProjectJniDirectories = ImmutableSet.of();
    private Set<VirtualFile> myProjectJniFiles = ImmutableSet.of();
    private Map<String, ModuleResolveConfiguration> myResolveConfigurations = ImmutableMap.of();

    public static GradleWorkspace getInstance(Project project) {
        return (GradleWorkspace)((Object)project.getComponent(GradleWorkspace.class));
    }

    public GradleWorkspace(Project project) {
        super(project);
        if (!Projects.isBuildWithGradle((Project)project)) {
            GradleWorkspace.setCppSupportDisabled(project, true);
        }
        this.myTrackers = new OCWorkspaceModificationTrackers(project);
        GradleSyncState.subscribe((Project)this.myProject, (GradleSyncListener)new GradleSyncListener.Adapter(){

            public void syncSucceeded(Project project) {
                GradleWorkspace.this.scheduleGradleWorkspaceUpdate();
            }

            public void syncFailed(Project project, String errorMessage) {
                GradleWorkspace.this.scheduleGradleWorkspaceUpdate();
            }

            public void syncSkipped(Project project) {
                GradleWorkspace.this.scheduleGradleWorkspaceUpdate();
            }
        });
    }

    private static void setCppSupportDisabled(Project project, boolean disabled) {
        project.putUserData(OCParserDefinition.CPP_SUPPORT_DISABLED, (Object)disabled);
    }

    private void scheduleGradleWorkspaceUpdate() {
        this.myProjectJniDirectories = ImmutableSet.of();
        this.myProjectJniFiles = ImmutableSet.of();
        this.myResolveConfigurations = ImmutableMap.of();
        GradleWorkspace.setCppSupportDisabled(this.myProject, false);
        new Task.Backgroundable(this.myProject, "Resolving C/C++ Configurations", false){

            public void run(ProgressIndicator indicator) {
                GradleWorkspace.this.updateGradleWorkspace(indicator);
            }
        }.queue();
    }

    private void updateGradleWorkspace(ProgressIndicator indicator) {
        indicator.setIndeterminate(true);
        String incompatibleModelVersion = GradleWorkspace.getModelVersionIfIncompatible(this.myProject);
        boolean isNdkSpecified = this.isNdkDefined() && SdkPaths.validateAndroidNdk((File)this.getNdkPath(), (boolean)false).success;
        HashSet projectJniDirectories = Sets.newHashSet();
        HashSet projectJniFiles = Sets.newHashSet();
        HashMap projectResolveConfigurations = Maps.newHashMap();
        ArrayList nativeModules = Lists.newArrayList();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        for (Module module : moduleManager.getModules()) {
            AndroidGradleModel androidModel;
            AndroidFacet facet = AndroidFacet.getInstance((Module)module);
            if (facet == null || (androidModel = AndroidGradleModel.get((AndroidFacet)facet)) == null) continue;
            Set<VirtualFile> moduleJniDirectories = GradleWorkspace.getJniDirectories(facet);
            Set<VirtualFile> moduleJniFiles = GradleWorkspace.getJniFiles(moduleJniDirectories);
            if (!moduleJniFiles.isEmpty()) {
                if (incompatibleModelVersion != null) {
                    GradleWorkspace.addModelVersionIncompatibilityNotification(incompatibleModelVersion, this.myProject);
                    return;
                }
                if (!isNdkSpecified) {
                    this.addNdkNotSpecifiedNotification(this.myProject, this.isNdkDefined());
                    return;
                }
            }
            Map<String, ModuleResolveConfiguration> moduleResolveConfigurations = this.getResolveConfigurations(this.myProject, this.myCompilerInfoCache, androidModel);
            if (!moduleJniFiles.isEmpty() && !moduleResolveConfigurations.isEmpty()) {
                nativeModules.add(module);
            }
            projectJniDirectories.addAll(moduleJniDirectories);
            projectJniFiles.addAll(moduleJniFiles);
            projectResolveConfigurations.putAll(moduleResolveConfigurations);
        }
        this.myProjectJniDirectories = ImmutableSet.copyOf((Collection)projectJniDirectories);
        this.myProjectJniFiles = ImmutableSet.copyOf((Collection)projectJniFiles);
        this.myResolveConfigurations = ImmutableMap.copyOf((Map)projectResolveConfigurations);
        if (!this.myProjectJniFiles.isEmpty() && !this.myResolveConfigurations.isEmpty()) {
            UsageTracker.getInstance().trackEvent("gradle", "cppSyncCompleted", null, null);
        }
        new ReadAction(){

            protected void run(Result result) throws Throwable {
                if (GradleWorkspace.this.myProject.isDisposed()) {
                    return;
                }
                GradleWorkspace.this.myTrackers.getProjectFilesListTracker().incModificationCount();
                GradleWorkspace.this.myTrackers.getSourceFilesListTracker().incModificationCount();
                GradleWorkspace.this.myTrackers.getBuildConfigurationChangesTracker().incModificationCount();
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    GradleWorkspace.this.myTrackers.getBuildSettingsChangesTracker().incModificationCount();
                }
            }
        }.execute();
        GradleWorkspace.createAndroidNativeRunConfigurations(this.myProject, nativeModules);
    }

    private static String getModelVersionIfIncompatible(Project project) {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            AndroidProject androidProject;
            String version;
            AndroidGradleModel androidModel;
            AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module);
            if (androidFacet == null || (androidModel = AndroidGradleModel.get((AndroidFacet)androidFacet)) == null || (version = GradleWorkspace.getModelVersionIfIncompatible(androidProject = androidModel.getAndroidProject())) == null) continue;
            return version;
        }
        return null;
    }

    private static void addModelVersionIncompatibilityNotification(String modelVersion, Project project) {
        String text = String.format("Android plugin version %1$s is not compatible with the NDK support. ", modelVersion) + "Please use the experimental plugin.";
        ProjectSyncMessages.getInstance((Project)project).add(new Message("Gradle Sync Issue", Message.Type.WARNING, new String[]{text}), new NotificationHyperlink[0]);
        String title = "Incompatible Android Plugin Version";
        AndroidGradleNotification.getInstance((Project)project).showBalloon(title, text, NotificationType.WARNING);
    }

    private void addNdkNotSpecifiedNotification(Project project, boolean isNdkDefined) {
        boolean ndkInSdk = this.isNdkInSdk();
        NotificationHyperlink downloadLink = NdkLocationNotFoundErrorHandler.getSelectNdkNotificationHyperlink((!ndkInSdk ? 1 : 0) != 0);
        AndroidGradleNotification.getInstance((Project)project).showBalloon("Project Sync Error", String.format("Android NDK location is not %1$s.", isNdkDefined ? "valid" : "specified"), NotificationType.ERROR, new NotificationHyperlink[]{downloadLink});
    }

    private static Set<VirtualFile> getJniDirectories(AndroidFacet facet) {
        HashSet jniDirectories = Sets.newHashSet();
        for (IdeaSourceProvider provider : IdeaSourceProvider.getAllIdeaSourceProviders((AndroidFacet)facet)) {
            jniDirectories.addAll(provider.getJniDirectories());
        }
        return jniDirectories;
    }

    private static Set<VirtualFile> getJniFiles(Set<VirtualFile> jniDirectories) {
        final HashSet jniFiles = Sets.newHashSet();
        for (VirtualFile directory : jniDirectories) {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)directory, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(VirtualFile file) {
                    if (file.getFileType() == OCFileType.INSTANCE) {
                        jniFiles.add(file);
                    }
                    return true;
                }
            });
        }
        return jniFiles;
    }

    private Map<String, ModuleResolveConfiguration> getResolveConfigurations(Project project, NdkCompilerInfoCache compilerInfoCache, AndroidGradleModel androidModel) {
        HashMap configurations = Maps.newHashMap();
        AndroidProject androidProject = androidModel.getAndroidProject();
        Map<String, NativeToolchain> toolchains = GradleWorkspace.getToolchainsByName(androidProject);
        for (Variant variant : androidProject.getVariants()) {
            Collection<NativeLibrary> nativeLibraries = GradleWorkspace.getNativeLibraries(variant, androidProject);
            for (NativeLibrary library : nativeLibraries) {
                NativeToolchain toolchain = toolchains.get(library.getToolchainName());
                String key = GradleWorkspace.getResolvedConfigurationKey(androidModel.getModuleName(), variant.getName(), library.getAbi());
                if (toolchain == null || configurations.containsKey(key)) continue;
                ModuleResolveConfiguration configuration = new ModuleResolveConfiguration(project, androidModel.getRootDirPath(), compilerInfoCache, library, toolchain);
                configurations.put(key, configuration);
            }
        }
        return configurations;
    }

    private static Map<String, NativeToolchain> getToolchainsByName(AndroidProject androidProject) {
        if (GradleWorkspace.isModelVersionIncompatible(androidProject)) {
            return Collections.emptyMap();
        }
        HashMap toolchains = Maps.newHashMap();
        for (NativeToolchain toolchain : androidProject.getNativeToolchains()) {
            toolchains.put(toolchain.getName(), toolchain);
        }
        return toolchains;
    }

    private static String getResolvedConfigurationKey(String moduleName, String variantName, String abi) {
        return moduleName + ":" + variantName + ":" + abi;
    }

    private static void createAndroidNativeRunConfigurations(Project project, List<Module> nativeModules) {
        for (Module module : nativeModules) {
            AndroidFacet facet = AndroidFacet.getInstance((Module)module);
            if (facet == null || facet.isLibraryProject()) continue;
            RunManager runManager = RunManager.getInstance((Project)project);
            ConfigurationFactory configurationFactory = AndroidNativeRunConfigurationType.getInstance().getFactory();
            List configs = runManager.getConfigurationsList(configurationFactory.getType());
            boolean found = false;
            for (RunConfiguration config : configs) {
                AndroidNativeRunConfiguration androidNativeRunConfig;
                if (!(config instanceof AndroidNativeRunConfiguration) || ((JavaRunConfigurationModule)(androidNativeRunConfig = (AndroidNativeRunConfiguration)config).getConfigurationModule()).getModule() != module) continue;
                found = true;
                break;
            }
            if (found) continue;
            RunnerAndConfigurationSettings settings = runManager.createRunConfiguration(module.getName() + "-native", configurationFactory);
            AndroidNativeRunConfiguration configuration = (AndroidNativeRunConfiguration)settings.getConfiguration();
            configuration.setModule(module);
            configuration.setTargetSelectionMode(TargetSelectionMode.SHOW_DIALOG);
            runManager.addConfiguration(settings, false);
        }
    }

    public boolean isNdkDefined() {
        return this.getNdkPath() != null;
    }

    public File getNdkPath() {
        try {
            return new LocalProperties(this.myProject).getAndroidNdkPath();
        }
        catch (IOException e) {
            String msg = String.format("Unable to read local.properties file of Project '%1$s'", this.myProject.getName());
            LOG.info(msg, (Throwable)e);
            return null;
        }
    }

    public File getSdkPath() {
        try {
            return new LocalProperties(this.myProject).getAndroidSdkPath();
        }
        catch (IOException e) {
            String msg = String.format("Unable to read local.properties file of Project '%1$s'", this.myProject.getName());
            LOG.info(msg, (Throwable)e);
            return null;
        }
    }

    private boolean isNdkInSdk() {
        return this.getNdkPath() != null && FileUtil.filesEqual((File)this.getNdkPath().getParentFile(), (File)this.getSdkPath());
    }

    public boolean isInProject(VirtualFile file) {
        return this.myProjectJniFiles.contains(file);
    }

    public boolean isInProjectDirectories(VirtualFile file) {
        for (VirtualFile directory : this.myProjectJniDirectories) {
            if (!VfsUtil.isAncestor((VirtualFile)directory, (VirtualFile)file, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    public boolean isInLibraries(VirtualFile file) {
        return false;
    }

    public boolean isInSDK(VirtualFile file) {
        return false;
    }

    public Collection<VirtualFile> getProjectFiles() {
        return this.myProjectJniFiles;
    }

    public Iterable<VirtualFile> getProjectFilesByName(String fileName) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)2);
        for (VirtualFile file : this.getProjectFiles()) {
            if (!file.getName().equals(fileName)) continue;
            result.add(file);
        }
        return result;
    }

    public boolean areFromSameProject(VirtualFile a, VirtualFile b) {
        return false;
    }

    public boolean areFromSamePackage(VirtualFile a, VirtualFile b) {
        return false;
    }

    public boolean isFromWrongSDK(OCSymbol symbol, VirtualFile contextFile) {
        return false;
    }

    public Collection<VirtualFile> getLibraryFiles() {
        return Collections.emptyList();
    }

    public Collection<? extends VirtualFile> getLibraryFilesToBuildSymbols() {
        return this.getLibraryFiles();
    }

    public List<? extends OCResolveConfiguration> getConfigurations() {
        return Lists.newArrayList(this.myResolveConfigurations.values());
    }

    public List<? extends OCResolveConfiguration> getConfigurationsForFile(VirtualFile file) {
        ArrayList configurations;
        block4: {
            block5: {
                AndroidGradleModel androidModel;
                if (this.myResolveConfigurations.isEmpty()) {
                    return ImmutableList.of();
                }
                configurations = Lists.newArrayList();
                if (file == null) break block4;
                Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)this.myProject);
                if (module == null) break block5;
                AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module);
                if (androidFacet == null || (androidModel = AndroidGradleModel.get((AndroidFacet)androidFacet)) == null) break block4;
                Variant variant = androidModel.getSelectedVariant();
                Collection<NativeLibrary> nativeLibraries = GradleWorkspace.getNativeLibraries(variant, androidModel.getAndroidProject());
                for (NativeLibrary nativeLibrary : nativeLibraries) {
                    String key = GradleWorkspace.getResolvedConfigurationKey(module.getName(), variant.getName(), nativeLibrary.getAbi());
                    ModuleResolveConfiguration configuration = this.myResolveConfigurations.get(key);
                    if (configuration == null) continue;
                    configurations.add(configuration);
                }
                break block4;
            }
            block1: for (ModuleResolveConfiguration configuration : this.myResolveConfigurations.values()) {
                HeaderRoots headerRoots = configuration.getLibraryHeadersRoots(new OCResolveRootAndConfiguration(null, file));
                for (PsiFileSystemItem root : headerRoots.getRoots()) {
                    VirtualFile rootFile = root.getVirtualFile();
                    if (rootFile == null || !VfsUtilCore.isAncestor((VirtualFile)rootFile, (VirtualFile)file, (boolean)true)) continue;
                    configurations.add(configuration);
                    continue block1;
                }
            }
        }
        return configurations;
    }

    private static Collection<NativeLibrary> getNativeLibraries(Variant variant, AndroidProject androidProject) {
        if (GradleWorkspace.isModelVersionIncompatible(androidProject)) {
            return Collections.emptyList();
        }
        AndroidArtifact mainArtifact = variant.getMainArtifact();
        Collection nativeLibraries = mainArtifact.getNativeLibraries();
        if (nativeLibraries != null) {
            return nativeLibraries;
        }
        return Collections.emptyList();
    }

    private static boolean isModelVersionIncompatible(AndroidProject androidProject) {
        return GradleWorkspace.getModelVersionIfIncompatible(androidProject) != null;
    }

    private static String getModelVersionIfIncompatible(AndroidProject androidProject) {
        String modelVersion = androidProject.getModelVersion();
        if (!modelVersion.startsWith("1.0") && !modelVersion.startsWith("1.1") && androidProject.getApiVersion() >= 3) {
            return null;
        }
        return modelVersion;
    }

    public OCResolveConfiguration getSelectedResolveConfiguration() {
        return null;
    }

    public OCWorkspaceModificationTrackers getModificationTrackers() {
        return this.myTrackers;
    }
}

