/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Future;
import org.jetbrains.jps.builders.java.JavaCompilingTool;
import org.jetbrains.jps.cmdline.ClasspathBootstrap;
import org.jetbrains.jps.javac.ExternalJavacProcess;
import org.jetbrains.jps.service.SharedThreadPool;

public class JavacServerBootstrap {
    public static ExternalJavacProcessHandler launchExternalJavacProcess(UUID uuid, String sdkHomePath, int heapSize, int port, File workingDir, List<String> vmOptions, JavaCompilingTool compilingTool) throws Exception {
        String region;
        String country;
        String lang;
        ArrayList<String> cmdLine = new ArrayList<String>();
        JavacServerBootstrap.appendParam(cmdLine, JavacServerBootstrap.getVMExecutablePath(sdkHomePath));
        JavacServerBootstrap.appendParam(cmdLine, "-Djava.awt.headless=true");
        int xms = heapSize / 2;
        if (xms > 32) {
            JavacServerBootstrap.appendParam(cmdLine, "-Xms" + xms + "m");
        }
        JavacServerBootstrap.appendParam(cmdLine, "-Xmx" + heapSize + "m");
        String encoding = System.getProperty("file.encoding");
        if (encoding != null) {
            JavacServerBootstrap.appendParam(cmdLine, "-Dfile.encoding=" + encoding);
        }
        if ((lang = System.getProperty("user.language")) != null) {
            JavacServerBootstrap.appendParam(cmdLine, "-Duser.language=" + lang);
        }
        if ((country = System.getProperty("user.country")) != null) {
            JavacServerBootstrap.appendParam(cmdLine, "-Duser.country=" + country);
        }
        if ((region = System.getProperty("user.region")) != null) {
            JavacServerBootstrap.appendParam(cmdLine, "-Duser.region=" + region);
        }
        JavacServerBootstrap.appendParam(cmdLine, "-Djps.java.compiling.tool=" + compilingTool.getId());
        JavacServerBootstrap.appendParam(cmdLine, "-Djava.ext.dirs=");
        JavacServerBootstrap.appendParam(cmdLine, "-Dlog4j.defaultInitOverride=true");
        for (String option : vmOptions) {
            JavacServerBootstrap.appendParam(cmdLine, option);
        }
        JavacServerBootstrap.appendParam(cmdLine, "-classpath");
        List<File> cp = ClasspathBootstrap.getExternalJavacProcessClasspath(sdkHomePath, compilingTool);
        StringBuilder classpath = new StringBuilder();
        for (File file : cp) {
            if (classpath.length() > 0) {
                classpath.append(File.pathSeparator);
            }
            classpath.append(file.getPath());
        }
        JavacServerBootstrap.appendParam(cmdLine, classpath.toString());
        JavacServerBootstrap.appendParam(cmdLine, ExternalJavacProcess.class.getName());
        JavacServerBootstrap.appendParam(cmdLine, uuid.toString());
        JavacServerBootstrap.appendParam(cmdLine, "127.0.0.1");
        JavacServerBootstrap.appendParam(cmdLine, Integer.toString(port));
        workingDir.mkdirs();
        JavacServerBootstrap.appendParam(cmdLine, FileUtil.toSystemIndependentName((String)workingDir.getPath()));
        ProcessBuilder builder = new ProcessBuilder(cmdLine);
        builder.directory(workingDir);
        Process process = builder.start();
        final ExternalJavacProcessHandler processHandler = new ExternalJavacProcessHandler(process);
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                processHandler.setExitCode(event.getExitCode());
            }

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                String text = event.getText();
                if (!StringUtil.isEmptyOrSpaces((String)text)) {
                    if (outputType == ProcessOutputTypes.STDOUT) {
                        System.out.print("JAVAC_PROCESS: " + text);
                    } else if (outputType == ProcessOutputTypes.STDERR) {
                        System.err.print("JAVAC_PROCESS: " + text);
                    }
                }
            }
        });
        processHandler.startNotify();
        return processHandler;
    }

    private static void appendParam(List<String> cmdLine, String param) {
        if (SystemInfo.isWindows) {
            if (param.contains("\"")) {
                param = StringUtil.replace((String)param, (String)"\"", (String)"\\\"");
            } else if (param.length() == 0) {
                param = "\"\"";
            }
        }
        cmdLine.add(param);
    }

    public static String getVMExecutablePath(String sdkHome) {
        return sdkHome + "/bin/java";
    }

    public static class ExternalJavacProcessHandler
    extends BaseOSProcessHandler {
        private volatile int myExitCode;

        ExternalJavacProcessHandler(Process process) {
            super(process, null, null);
        }

        protected Future<?> executeOnPooledThread(Runnable task) {
            return SharedThreadPool.getInstance().executeOnPooledThread(task);
        }

        void setExitCode(int exitCode) {
            this.myExitCode = exitCode;
        }

        public int getExitCode() {
            return this.myExitCode;
        }
    }
}

