/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import com.google.protobuf.MessageLite;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.protobuf.ProtobufDecoder;
import io.netty.handler.codec.protobuf.ProtobufEncoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32FrameDecoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32LengthFieldPrepender;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.Log4JLoggerFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.jetbrains.jps.api.CanceledStatus;
import org.jetbrains.jps.builders.impl.java.JavacCompilerTool;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.JavaCompilingTool;
import org.jetbrains.jps.javac.DiagnosticOutputConsumer;
import org.jetbrains.jps.javac.JavacMain;
import org.jetbrains.jps.javac.JavacProtoUtil;
import org.jetbrains.jps.javac.JavacRemoteProto;
import org.jetbrains.jps.javac.OutputFileConsumer;
import org.jetbrains.jps.javac.OutputFileObject;
import org.jetbrains.jps.service.SharedThreadPool;

public class ExternalJavacProcess {
    public static final String JPS_JAVA_COMPILING_TOOL_PROPERTY = "jps.java.compiling.tool";
    private final ChannelInitializer myChannelInitializer;
    private final EventLoopGroup myEventLoopGroup;
    private volatile ChannelFuture myConnectFuture;
    private volatile CancelHandler myCancelHandler;

    public ExternalJavacProcess() {
        final JavacRemoteProto.Message msgDefaultInstance = JavacRemoteProto.Message.getDefaultInstance();
        this.myEventLoopGroup = new NioEventLoopGroup(1, (Executor)SharedThreadPool.getInstance());
        this.myChannelInitializer = new ChannelInitializer(){

            protected void initChannel(Channel channel) throws Exception {
                channel.pipeline().addLast(new ChannelHandler[]{new ProtobufVarint32FrameDecoder(), new ProtobufDecoder((MessageLite)msgDefaultInstance), new ProtobufVarint32LengthFieldPrepender(), new ProtobufEncoder(), new CompilationRequestsHandler()});
            }
        };
    }

    public static void main(String[] args) {
        UUID uuid = null;
        String host = null;
        int port = -1;
        if (args.length > 0) {
            try {
                uuid = UUID.fromString(args[0]);
            }
            catch (Exception e) {
                System.err.println("Error parsing session id: " + e.getMessage());
                System.exit(-1);
            }
            host = args[1];
            try {
                port = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException e) {
                System.err.println("Error parsing port: " + e.getMessage());
                System.exit(-1);
            }
        } else {
            System.err.println("Insufficient parameters");
            System.exit(-1);
        }
        ExternalJavacProcess process = new ExternalJavacProcess();
        try {
            if (process.connect(host, port)) {
                process.myConnectFuture.channel().writeAndFlush((Object)JavacProtoUtil.toMessage(uuid, JavacProtoUtil.createRequestAckResponse()));
            } else {
                System.err.println("Failed to connect to parent process");
                System.exit(-1);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
            System.exit(-1);
        }
    }

    private boolean connect(String host, int port) throws Throwable {
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.myEventLoopGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)this.myChannelInitializer);
        ((Bootstrap)bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true);
        ChannelFuture future = bootstrap.connect(host, port).syncUninterruptibly();
        if (future.isSuccess()) {
            this.myConnectFuture = future;
            return true;
        }
        return false;
    }

    private static JavacRemoteProto.Message compile(final ChannelHandlerContext context, final UUID sessionId, List<String> options, Collection<File> files, Collection<File> classpath, Collection<File> platformCp, Collection<File> sourcePath, Map<File, Set<File>> outs, CanceledStatus canceledStatus) {
        DiagnosticOutputConsumer diagnostic = new DiagnosticOutputConsumer(){

            @Override
            public void javaFileLoaded(File file) {
                context.channel().writeAndFlush((Object)JavacProtoUtil.toMessage(sessionId, JavacProtoUtil.createSourceFileLoadedResponse(file)));
            }

            @Override
            public void outputLineAvailable(String line) {
                context.channel().writeAndFlush((Object)JavacProtoUtil.toMessage(sessionId, JavacProtoUtil.createStdOutputResponse(line)));
            }

            @Override
            public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                JavacRemoteProto.Message.Response response = JavacProtoUtil.createBuildMessageResponse(diagnostic);
                context.channel().writeAndFlush((Object)JavacProtoUtil.toMessage(sessionId, response));
            }

            @Override
            public void registerImports(String className, Collection<String> imports, Collection<String> staticImports) {
                JavacRemoteProto.Message.Response response = JavacProtoUtil.createClassDataResponse(className, imports, staticImports);
                context.channel().writeAndFlush((Object)JavacProtoUtil.toMessage(sessionId, response));
            }
        };
        OutputFileConsumer outputSink = new OutputFileConsumer(){

            @Override
            public void save(OutputFileObject fileObject) {
                context.channel().writeAndFlush((Object)JavacProtoUtil.toMessage(sessionId, JavacProtoUtil.createOutputObjectResponse(fileObject)));
            }
        };
        try {
            JavaCompilingTool tool = ExternalJavacProcess.getCompilingTool();
            boolean rc = JavacMain.compile(options, files, classpath, platformCp, sourcePath, outs, diagnostic, outputSink, canceledStatus, tool);
            return JavacProtoUtil.toMessage(sessionId, JavacProtoUtil.createBuildCompletedResponse(rc));
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            return JavacProtoUtil.toMessage(sessionId, JavacProtoUtil.createFailure(e.getMessage(), e));
        }
    }

    private static JavaCompilingTool getCompilingTool() {
        JavaCompilingTool tool;
        String property = System.getProperty(JPS_JAVA_COMPILING_TOOL_PROPERTY);
        if (property != null && (tool = JavaBuilderUtil.findCompilingTool(property)) != null) {
            return tool;
        }
        return new JavacCompilerTool();
    }

    public void stop() {
        try {
            ChannelFuture future = this.myConnectFuture;
            if (future != null) {
                future.channel().close().await();
            }
            this.myEventLoopGroup.shutdownGracefully(0L, 15L, TimeUnit.SECONDS).await();
            System.exit(0);
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            System.exit(-1);
        }
    }

    private static List<File> toFiles(List<String> paths) {
        ArrayList<File> files = new ArrayList<File>(paths.size());
        for (String path : paths) {
            files.add(new File(path));
        }
        return files;
    }

    public void cancelBuild() {
        CancelHandler cancelHandler = this.myCancelHandler;
        if (cancelHandler != null) {
            cancelHandler.cancel();
        }
    }

    static {
        Logger root = Logger.getRootLogger();
        if (!root.getAllAppenders().hasMoreElements()) {
            root.setLevel(Level.INFO);
            root.addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("%m%n")));
        }
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new Log4JLoggerFactory());
    }

    private static class CancelHandler
    implements CanceledStatus {
        private volatile boolean myIsCanceled = false;

        private CancelHandler() {
        }

        public void cancel() {
            this.myIsCanceled = true;
        }

        @Override
        public boolean isCanceled() {
            return this.myIsCanceled;
        }
    }

    @ChannelHandler.Sharable
    private class CompilationRequestsHandler
    extends SimpleChannelInboundHandler<JavacRemoteProto.Message> {
        private CompilationRequestsHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void channelRead0(final ChannelHandlerContext context, JavacRemoteProto.Message message) throws Exception {
            final UUID sessionId = JavacProtoUtil.fromProtoUUID(message.getSessionId());
            JavacRemoteProto.Message.Type messageType = message.getMessageType();
            JavacRemoteProto.Message reply = null;
            try {
                if (messageType == JavacRemoteProto.Message.Type.REQUEST) {
                    JavacRemoteProto.Message.Request request = message.getRequest();
                    JavacRemoteProto.Message.Request.Type requestType = request.getRequestType();
                    if (requestType == JavacRemoteProto.Message.Request.Type.COMPILE) {
                        if (ExternalJavacProcess.this.myCancelHandler == null) {
                            final List<String> options = request.getOptionList();
                            final List files = ExternalJavacProcess.toFiles(request.getFileList());
                            final List cp = ExternalJavacProcess.toFiles(request.getClasspathList());
                            final List platformCp = ExternalJavacProcess.toFiles(request.getPlatformClasspathList());
                            final List srcPath = ExternalJavacProcess.toFiles(request.getSourcepathList());
                            final HashMap outs = new HashMap();
                            for (JavacRemoteProto.Message.Request.OutputGroup outputGroup : request.getOutputList()) {
                                HashSet<File> srcRoots = new HashSet<File>();
                                for (String root : outputGroup.getSourceRootList()) {
                                    srcRoots.add(new File(root));
                                }
                                outs.put(new File(outputGroup.getOutputRoot()), srcRoots);
                            }
                            final CancelHandler cancelHandler = new CancelHandler();
                            ExternalJavacProcess.this.myCancelHandler = cancelHandler;
                            SharedThreadPool.getInstance().executeOnPooledThread(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    try {
                                        context.channel().writeAndFlush((Object)ExternalJavacProcess.compile(context, sessionId, options, files, cp, platformCp, srcPath, outs, cancelHandler)).awaitUninterruptibly();
                                    }
                                    finally {
                                        ExternalJavacProcess.this.myCancelHandler = null;
                                        ExternalJavacProcess.this.stop();
                                    }
                                }
                            });
                        }
                    } else if (requestType == JavacRemoteProto.Message.Request.Type.CANCEL) {
                        ExternalJavacProcess.this.cancelBuild();
                    } else if (requestType == JavacRemoteProto.Message.Request.Type.SHUTDOWN) {
                        ExternalJavacProcess.this.cancelBuild();
                        new Thread("StopThread"){

                            @Override
                            public void run() {
                                ExternalJavacProcess.this.stop();
                            }
                        }.start();
                    } else {
                        reply = JavacProtoUtil.toMessage(sessionId, JavacProtoUtil.createFailure("Unsupported request type: " + requestType.name(), null));
                    }
                } else {
                    reply = JavacProtoUtil.toMessage(sessionId, JavacProtoUtil.createFailure("Unsupported message: " + messageType.name(), null));
                }
                if (reply == null) return;
            }
            catch (Throwable throwable) {
                if (reply == null) throw throwable;
                context.channel().writeAndFlush(reply);
                throw throwable;
            }
            context.channel().writeAndFlush((Object)reply);
        }
    }
}

