/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.fs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.IOUtil;
import gnu.trove.TObjectLongHashMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.impl.BuildTargetChunk;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompileScope;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.TargetTypeRegistry;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.fs.CompilationRound;
import org.jetbrains.jps.incremental.fs.FilesDelta;
import org.jetbrains.jps.incremental.storage.Timestamps;
import org.jetbrains.jps.model.JpsModel;

public class BuildFSState {
    public static final int VERSION = 3;
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.incremental.fs.BuildFSState");
    private static final Key<Set<? extends BuildTarget<?>>> CONTEXT_TARGETS_KEY = Key.create((String)"_fssfate_context_targets_");
    private static final Key<FilesDelta> NEXT_ROUND_DELTA_KEY = Key.create((String)"_next_round_delta_");
    private static final Key<FilesDelta> CURRENT_ROUND_DELTA_KEY = Key.create((String)"_current_round_delta_");
    private final boolean myAlwaysScanFS;
    private final Set<BuildTarget<?>> myInitialScanPerformed = Collections.synchronizedSet(new HashSet());
    private final TObjectLongHashMap<File> myRegistrationStamps = new TObjectLongHashMap(FileUtil.FILE_HASHING_STRATEGY);
    private final Map<BuildTarget<?>, FilesDelta> myDeltas = Collections.synchronizedMap(new HashMap());

    public BuildFSState(boolean alwaysScanFS) {
        this.myAlwaysScanFS = alwaysScanFS;
    }

    public void save(DataOutput out) throws IOException {
        MultiMap targetsByType = new MultiMap();
        for (BuildTarget<?> target : this.myInitialScanPerformed) {
            targetsByType.putValue(target.getTargetType(), target);
        }
        out.writeInt(targetsByType.size());
        for (BuildTargetType type : targetsByType.keySet()) {
            IOUtil.writeString((String)type.getTypeId(), (DataOutput)out);
            Collection targets = targetsByType.get((Object)type);
            out.writeInt(targets.size());
            for (BuildTarget target : targets) {
                IOUtil.writeString((String)target.getId(), (DataOutput)out);
                this.getDelta(target).save(out);
            }
        }
    }

    public void load(DataInputStream in, JpsModel model, BuildRootIndex buildRootIndex) throws IOException {
        TargetTypeRegistry registry = TargetTypeRegistry.getInstance();
        int typeCount = in.readInt();
        while (typeCount-- > 0) {
            BuildTargetLoader<?> loader;
            String typeId = IOUtil.readString((DataInput)in);
            int targetCount = in.readInt();
            BuildTargetType<?> type = registry.getTargetType(typeId);
            BuildTargetLoader<?> buildTargetLoader = loader = type != null ? type.createLoader(model) : null;
            while (targetCount-- > 0) {
                Object target;
                String id = IOUtil.readString((DataInput)in);
                boolean loaded = false;
                if (loader != null && (target = loader.createTarget(id)) != null) {
                    this.getDelta((BuildTarget<?>)target).load(in, (BuildTarget<?>)target, buildRootIndex);
                    this.myInitialScanPerformed.add((BuildTarget<?>)target);
                    loaded = true;
                }
                if (loaded) continue;
                LOG.info("Skipping unknown target (typeId=" + typeId + ", type=" + type + ", id=" + id + ")");
                FilesDelta.skip(in);
            }
        }
    }

    public final void clearRecompile(BuildRootDescriptor rd) {
        this.getDelta(rd.getTarget()).clearRecompile(rd);
    }

    public long getEventRegistrationStamp(File file) {
        return this.myRegistrationStamps.get((Object)file);
    }

    public boolean hasWorkToDo(BuildTarget<?> target) {
        if (!this.myInitialScanPerformed.contains(target)) {
            return true;
        }
        FilesDelta delta = this.myDeltas.get(target);
        return delta != null && delta.hasChanges();
    }

    public void markInitialScanPerformed(BuildTarget<?> target) {
        this.myInitialScanPerformed.add(target);
    }

    public void registerDeleted(BuildTarget<?> target, File file, Timestamps tsStorage) throws IOException {
        this.registerDeleted(target, file);
        if (tsStorage != null) {
            tsStorage.removeStamp(file, target);
        }
    }

    public void registerDeleted(BuildTarget<?> target, File file) {
        this.getDelta(target).addDeleted(file);
    }

    public void clearDeletedPaths(BuildTarget<?> target) {
        FilesDelta delta = this.myDeltas.get(target);
        if (delta != null) {
            delta.clearDeletedPaths();
        }
    }

    public Collection<String> getAndClearDeletedPaths(BuildTarget<?> target) {
        FilesDelta delta = this.myDeltas.get(target);
        if (delta != null) {
            return delta.getAndClearDeletedPaths();
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FilesDelta getDelta(BuildTarget<?> buildTarget) {
        Map<BuildTarget<?>, FilesDelta> map = this.myDeltas;
        synchronized (map) {
            FilesDelta delta = this.myDeltas.get(buildTarget);
            if (delta == null) {
                delta = new FilesDelta();
                this.myDeltas.put(buildTarget, delta);
            }
            return delta;
        }
    }

    public boolean isInitialScanPerformed(BuildTarget<?> target) {
        return !this.myAlwaysScanFS && this.myInitialScanPerformed.contains(target);
    }

    public Map<BuildRootDescriptor, Set<File>> getSourcesToRecompile(CompileContext context, BuildTarget<?> target) {
        FilesDelta lastRoundDelta;
        if (target instanceof ModuleBuildTarget && (lastRoundDelta = BuildFSState.getRoundDelta(CURRENT_ROUND_DELTA_KEY, context)) != null) {
            return lastRoundDelta.getSourcesToRecompile();
        }
        return this.getDelta(target).getSourcesToRecompile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMarkedForRecompilation(CompileContext context, CompilationRound round, BuildRootDescriptor rd, File file) {
        Map<BuildRootDescriptor, Set<File>> recompile;
        FilesDelta delta = BuildFSState.getRoundDelta(round == CompilationRound.NEXT ? NEXT_ROUND_DELTA_KEY : CURRENT_ROUND_DELTA_KEY, context);
        if (delta == null) {
            delta = this.getDelta(rd.getTarget());
        }
        Map<BuildRootDescriptor, Set<File>> map = recompile = delta.getSourcesToRecompile();
        synchronized (map) {
            Set<File> files = recompile.get(rd);
            return files != null && files.contains(file);
        }
    }

    public final boolean markDirty(CompileContext context, File file, BuildRootDescriptor rd, Timestamps tsStorage, boolean saveEventStamp) throws IOException {
        return this.markDirty(context, CompilationRound.NEXT, file, rd, tsStorage, saveEventStamp);
    }

    public boolean markDirty(CompileContext context, CompilationRound round, File file, BuildRootDescriptor rd, Timestamps tsStorage, boolean saveEventStamp) throws IOException {
        boolean marked;
        FilesDelta roundDelta = BuildFSState.getRoundDelta(round == CompilationRound.NEXT ? NEXT_ROUND_DELTA_KEY : CURRENT_ROUND_DELTA_KEY, context);
        if (roundDelta != null && BuildFSState.isInCurrentContextTargets(context, rd)) {
            roundDelta.markRecompile(rd, file);
        }
        if (marked = this.getDelta(rd.getTarget()).markRecompile(rd, file)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(rd.getTarget() + ": MARKED DIRTY: " + file.getPath());
            }
            if (saveEventStamp) {
                this.myRegistrationStamps.put((Object)file, System.currentTimeMillis());
            }
            if (tsStorage != null) {
                tsStorage.removeStamp(file, rd.getTarget());
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug(rd.getTarget() + ": NOT MARKED DIRTY: " + file.getPath());
        }
        return marked;
    }

    private static boolean isInCurrentContextTargets(CompileContext context, BuildRootDescriptor rd) {
        if (context == null) {
            return false;
        }
        Set targets = (Set)CONTEXT_TARGETS_KEY.get((UserDataHolder)context, Collections.emptySet());
        return targets.contains(rd.getTarget());
    }

    public boolean markDirtyIfNotDeleted(CompileContext context, CompilationRound round, File file, BuildRootDescriptor rd, Timestamps tsStorage) throws IOException {
        FilesDelta roundDelta;
        boolean marked = this.getDelta(rd.getTarget()).markRecompileIfNotDeleted(rd, file);
        if (marked && tsStorage != null) {
            tsStorage.removeStamp(file, rd.getTarget());
        }
        if (marked && (roundDelta = BuildFSState.getRoundDelta(round == CompilationRound.NEXT ? NEXT_ROUND_DELTA_KEY : CURRENT_ROUND_DELTA_KEY, context)) != null && BuildFSState.isInCurrentContextTargets(context, rd)) {
            roundDelta.markRecompile(rd, file);
        }
        return marked;
    }

    public void clearAll() {
        this.clearContextRoundData(null);
        this.clearContextChunk(null);
        this.myInitialScanPerformed.clear();
        this.myDeltas.clear();
        this.myRegistrationStamps.clear();
    }

    public void clearContextRoundData(CompileContext context) {
        BuildFSState.setRoundDelta(NEXT_ROUND_DELTA_KEY, context, null);
        BuildFSState.setRoundDelta(CURRENT_ROUND_DELTA_KEY, context, null);
    }

    public void clearContextChunk(CompileContext context) {
        BuildFSState.setContextTargets(context, null);
    }

    public void beforeChunkBuildStart(CompileContext context, BuildTargetChunk chunk) {
        BuildFSState.setContextTargets(context, chunk.getTargets());
    }

    public void beforeNextRoundStart(CompileContext context, ModuleChunk chunk) {
        FilesDelta currentDelta = BuildFSState.getRoundDelta(NEXT_ROUND_DELTA_KEY, context);
        if (currentDelta == null) {
            currentDelta = new FilesDelta();
            for (ModuleBuildTarget target : chunk.getTargets()) {
                FilesDelta targetDelta = this.getDelta(target);
                currentDelta.addAll(targetDelta);
            }
        }
        BuildFSState.setRoundDelta(CURRENT_ROUND_DELTA_KEY, context, currentDelta);
        BuildFSState.setRoundDelta(NEXT_ROUND_DELTA_KEY, context, new FilesDelta());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends BuildRootDescriptor, T extends BuildTarget<R>> boolean processFilesToRecompile(CompileContext context, T target, FileProcessor<R, T> processor) throws IOException {
        Map<BuildRootDescriptor, Set<File>> data = this.getSourcesToRecompile(context, target);
        CompileScope scope = context.getScope();
        Map<BuildRootDescriptor, Set<File>> map = data;
        synchronized (map) {
            for (Map.Entry<BuildRootDescriptor, Set<File>> entry : data.entrySet()) {
                BuildRootDescriptor root = entry.getKey();
                if (!target.equals(root.getTarget())) continue;
                for (File file : entry.getValue()) {
                    if (!scope.isAffected(target, file) || processor.apply(target, file, root)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean markAllUpToDate(CompileContext context, BuildRootDescriptor rd, Timestamps stamps) throws IOException {
        boolean marked = false;
        FilesDelta delta = this.getDelta(rd.getTarget());
        Set<File> files = delta.clearRecompile(rd);
        if (files != null) {
            CompileScope scope = context.getScope();
            long compilationStartStamp = context.getCompilationStartStamp();
            for (File file : files) {
                if (scope.isAffected(rd.getTarget(), file)) {
                    long currentFileStamp = FileSystemUtil.lastModified((File)file);
                    if (!(rd.isGenerated() || currentFileStamp <= compilationStartStamp && this.getEventRegistrationStamp(file) <= compilationStartStamp)) {
                        if (Utils.IS_TEST_MODE) {
                            LOG.info("Timestamp after compilation started; marking dirty again: " + file.getPath());
                        }
                        delta.markRecompile(rd, file);
                        continue;
                    }
                    marked = true;
                    stamps.saveStamp(file, rd.getTarget(), currentFileStamp);
                    continue;
                }
                if (Utils.IS_TEST_MODE) {
                    LOG.info("Not affected by compile scope; marking dirty again: " + file.getPath());
                }
                delta.markRecompile(rd, file);
            }
        }
        return marked;
    }

    private static void setContextTargets(CompileContext context, Set<? extends BuildTarget<?>> targets) {
        if (context != null) {
            CONTEXT_TARGETS_KEY.set((UserDataHolder)context, targets);
        }
    }

    private static FilesDelta getRoundDelta(Key<FilesDelta> key, CompileContext context) {
        return context != null ? (FilesDelta)key.get((UserDataHolder)context) : null;
    }

    private static void setRoundDelta(Key<FilesDelta> key, CompileContext context, FilesDelta delta) {
        if (context != null) {
            key.set((UserDataHolder)context, (Object)delta);
        }
    }
}

