/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.InvalidUserDataException;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Path
implements Comparable<Path> {
    private static final Comparator<String> STRING_COMPARATOR = GUtil.caseInsensitive();
    private final String prefix;
    private final String[] segments;
    private final boolean absolute;
    public static final Path ROOT = new Path(":");

    public Path(String path) {
        assert (path.length() > 0);
        this.segments = StringUtils.split((String)path, (String)":");
        this.absolute = path.startsWith(":");
        this.prefix = path.endsWith(":") ? path : path + ":";
    }

    private Path(String[] segments, boolean absolute) {
        this.segments = segments;
        this.absolute = absolute;
        this.prefix = this.getPath() + ":";
    }

    public static Path path(String path) {
        return path.equals(":") ? ROOT : new Path(path);
    }

    public String toString() {
        return this.getPath();
    }

    public String getPath() {
        StringBuilder path = new StringBuilder();
        if (this.absolute) {
            path.append(":");
        }
        for (int i = 0; i < this.segments.length; ++i) {
            if (i > 0) {
                path.append(":");
            }
            String segment = this.segments[i];
            path.append(segment);
        }
        return path.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Path other = (Path)obj;
        return Arrays.equals(this.segments, other.segments);
    }

    public int hashCode() {
        return Arrays.hashCode(this.segments);
    }

    @Override
    public int compareTo(Path other) {
        if (this.absolute && !other.absolute) {
            return 1;
        }
        if (!this.absolute && other.absolute) {
            return -1;
        }
        for (int i = 0; i < Math.min(this.segments.length, other.segments.length); ++i) {
            int diff = STRING_COMPARATOR.compare(this.segments[i], other.segments[i]);
            if (diff == 0) continue;
            return diff;
        }
        int lenDiff = this.segments.length - other.segments.length;
        if (lenDiff > 0) {
            return 1;
        }
        if (lenDiff < 0) {
            return -1;
        }
        return 0;
    }

    public Path getParent() {
        if (this.segments.length == 0) {
            return null;
        }
        if (this.segments.length == 1) {
            return this.absolute ? ROOT : null;
        }
        String[] parentPath = new String[this.segments.length - 1];
        System.arraycopy(this.segments, 0, parentPath, 0, parentPath.length);
        return new Path(parentPath, this.absolute);
    }

    public String getName() {
        if (this.segments.length == 0) {
            return null;
        }
        return this.segments[this.segments.length - 1];
    }

    public Path resolve(String path) {
        return new Path(this.absolutePath(path));
    }

    public String absolutePath(String path) {
        if (!this.isAbsolutePath(path)) {
            return this.prefix + path;
        }
        return path;
    }

    public String relativePath(String path) {
        if (path.startsWith(this.prefix) && path.length() > this.prefix.length()) {
            return path.substring(this.prefix.length());
        }
        return path;
    }

    private boolean isAbsolutePath(String path) {
        if (!GUtil.isTrue(path)) {
            throw new InvalidUserDataException("A path must be specified!");
        }
        return path.startsWith(":");
    }
}

