/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.featurelifecycle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.runtime.StackTraceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeprecatedFeatureUsage {
    private final String message;
    private final Class<?> calledFrom;
    private final List<StackTraceElement> stack;

    public DeprecatedFeatureUsage(String message, Class<?> calledFrom) {
        this.message = message;
        this.calledFrom = calledFrom;
        this.stack = Collections.emptyList();
    }

    private DeprecatedFeatureUsage(DeprecatedFeatureUsage usage, List<StackTraceElement> stack) {
        this.message = usage.message;
        this.calledFrom = usage.calledFrom;
        this.stack = stack;
    }

    public String getMessage() {
        return this.message;
    }

    public List<StackTraceElement> getStack() {
        return this.stack;
    }

    public DeprecatedFeatureUsage withStackTrace() {
        int caller;
        if (!this.stack.isEmpty()) {
            return this;
        }
        StackTraceElement[] originalStack = StackTraceUtils.sanitize((Throwable)new Exception()).getStackTrace();
        for (caller = 0; caller < originalStack.length && !originalStack[caller].getClassName().startsWith(this.calledFrom.getName()); ++caller) {
        }
        while (caller < originalStack.length && originalStack[caller].getClassName().startsWith(this.calledFrom.getName())) {
            ++caller;
        }
        ++caller;
        ArrayList<StackTraceElement> stack = new ArrayList<StackTraceElement>();
        while (caller < originalStack.length) {
            stack.add(originalStack[caller]);
            ++caller;
        }
        return new DeprecatedFeatureUsage(this, stack);
    }
}

