/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.taskpath;

import java.util.Map;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.util.NameMatcher;

public class ProjectFinderByTaskPath {
    public ProjectInternal findProject(String projectPath, ProjectInternal startFrom) {
        if (projectPath.equals(":")) {
            return startFrom.getRootProject();
        }
        Project current = startFrom;
        if (projectPath.startsWith(":")) {
            current = current.getRootProject();
            projectPath = projectPath.substring(1);
        }
        String[] arr$ = projectPath.split(":");
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            NameMatcher matcher = new NameMatcher();
            String pattern = arr$[i$];
            Map<String, Project> children = current.getChildProjects();
            Project child = matcher.find(pattern, children);
            if (child == null) {
                throw new ProjectLookupException(matcher.formatErrorMessage("project", current));
            }
            current = child;
        }
        return current;
    }

    public static class ProjectLookupException
    extends InvalidUserDataException {
        public ProjectLookupException(String message) {
            super(message);
        }
    }
}

