/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import java.util.Set;
import org.gradle.api.Plugin;
import org.gradle.api.internal.plugins.PluginApplication;
import org.gradle.api.internal.plugins.PluginApplicationAction;
import org.gradle.api.plugins.PluginAware;
import org.gradle.model.internal.inspect.ModelRuleInspector;
import org.gradle.model.internal.inspect.RuleSourceDependencies;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.model.internal.registry.ModelRegistryScope;

public class PluginModelRuleExtractor
implements PluginApplicationAction {
    private final ModelRuleInspector inspector;

    public PluginModelRuleExtractor(ModelRuleInspector inspector) {
        this.inspector = inspector;
    }

    public void execute(PluginApplication pluginApplication) {
        Class<?> pluginClass = pluginApplication.getPlugin().getClass();
        Set sources = this.inspector.getDeclaredSources(pluginClass);
        if (!sources.isEmpty()) {
            PluginAware target = pluginApplication.getTarget();
            if (!(target instanceof ModelRegistryScope)) {
                throw new UnsupportedOperationException(String.format("Cannot apply model rules of plugin '%s' as the target '%s' is not model rule aware", pluginClass.getName(), target));
            }
            ModelRegistry modelRegistry = ((ModelRegistryScope)target).getModelRegistry();
            for (Class source : sources) {
                this.inspector.inspect(source, modelRegistry, (RuleSourceDependencies)new PluginRuleSourceDependencies(target));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PluginRuleSourceDependencies
    implements RuleSourceDependencies {
        private final PluginAware plugins;

        private PluginRuleSourceDependencies(PluginAware plugins) {
            this.plugins = plugins;
        }

        public void add(Class<?> source) {
            if (!Plugin.class.isAssignableFrom(source)) {
                throw new IllegalArgumentException("Only plugin classes are valid as rule source dependencies.");
            }
            this.plugins.getPlugins().apply(source);
        }
    }
}

