/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.wizards;

import com.intellij.CommonBundle;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectWizardStepFactory;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.projectImport.ProjectImportProvider;
import com.intellij.projectImport.SelectImportedProjectsStep;
import java.io.File;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.wizards.MavenProjectBuilder;
import org.jetbrains.idea.maven.wizards.MavenProjectImportStep;
import org.jetbrains.idea.maven.wizards.SelectProfilesStep;

public class MavenProjectImportProvider
extends ProjectImportProvider {
    public MavenProjectImportProvider(MavenProjectBuilder builder) {
        super((ProjectImportBuilder)builder);
    }

    public ModuleWizardStep[] createSteps(final WizardContext wizardContext) {
        ProjectWizardStepFactory stepFactory = ProjectWizardStepFactory.getInstance();
        return new ModuleWizardStep[]{new MavenProjectImportStep(wizardContext), new SelectProfilesStep(wizardContext), new SelectImportedProjectsStep<MavenProject>(wizardContext){

            protected String getElementText(MavenProject project) {
                String relPath;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(project.getMavenId());
                VirtualFile root = ((MavenProjectBuilder)this.getBuilder()).getRootDirectory();
                if (root != null && StringUtil.isNotEmpty((String)(relPath = VfsUtilCore.getRelativePath((VirtualFile)project.getDirectoryFile(), (VirtualFile)root, (char)File.separatorChar)))) {
                    stringBuilder.append(" [").append(relPath).append("]");
                }
                if (!this.isElementEnabled(project)) {
                    stringBuilder.append(" (project is ignored. See ").append(CommonBundle.settingsActionPath()).append(" | Maven | Ignored Files)");
                }
                return stringBuilder.toString();
            }

            protected boolean isElementEnabled(MavenProject mavenProject) {
                Project project = wizardContext.getProject();
                if (project == null) {
                    return true;
                }
                return !MavenProjectsManager.getInstance(project).isIgnored(mavenProject);
            }

            public void updateDataModel() {
                super.updateDataModel();
                this.getWizardContext().setProjectName(((MavenProjectBuilder)this.getBuilder()).getSuggestedProjectName());
            }

            public String getHelpId() {
                return "reference.dialogs.new.project.import.maven.page3";
            }
        }, stepFactory.createProjectJdkStep(wizardContext), stepFactory.createNameAndLocationStep(wizardContext)};
    }

    protected boolean canImportFromFile(VirtualFile file) {
        return "pom.xml".equals(file.getName());
    }

    public String getFileSample() {
        return "<b>Maven</b> project file (pom.xml)";
    }
}

