/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.services;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Property;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenRepositoryInfo;
import org.jetbrains.idea.maven.services.MavenRepositoryService;
import org.jetbrains.idea.maven.services.artifactory.ArtifactoryRepositoryService;
import org.jetbrains.idea.maven.services.nexus.NexusRepositoryService;
import org.jetbrains.idea.maven.utils.MavenLog;

@State(name="MavenServices", storages={@Storage(file="$APP_CONFIG$/mavenServices.xml")})
public class MavenRepositoryServicesManager
implements PersistentStateComponent<MavenRepositoryServicesManager> {
    private final List<String> myUrls = new ArrayList<String>();

    public MavenRepositoryServicesManager() {
        this.myUrls.add("http://oss.sonatype.org/service/local/");
        this.myUrls.add("http://repo.jfrog.org/artifactory/api/");
        this.myUrls.add("https://repository.jboss.org/nexus/service/local/");
    }

    public static MavenRepositoryServicesManager getInstance() {
        return (MavenRepositoryServicesManager)ServiceManager.getService(MavenRepositoryServicesManager.class);
    }

    public static MavenRepositoryService[] getServices() {
        return new MavenRepositoryService[]{new NexusRepositoryService(), new ArtifactoryRepositoryService()};
    }

    public static String[] getServiceUrls() {
        return ArrayUtil.toStringArray(MavenRepositoryServicesManager.getInstance().getUrls());
    }

    @Property(surroundWithTag=false)
    @AbstractCollection(surroundWithTag=false, elementTag="service-url", elementValueAttribute="")
    public List<String> getUrls() {
        return this.myUrls;
    }

    public void setUrls(List<String> urls) {
        if (this.myUrls != urls) {
            this.myUrls.clear();
            this.myUrls.addAll(urls);
        }
    }

    public MavenRepositoryServicesManager getState() {
        return this;
    }

    public void loadState(MavenRepositoryServicesManager state) {
        this.myUrls.clear();
        this.myUrls.addAll(state.getUrls());
    }

    public static List<MavenRepositoryInfo> getRepositories(String url) {
        SmartList result = new SmartList();
        for (MavenRepositoryService service : MavenRepositoryServicesManager.getServices()) {
            try {
                result.addAll(service.getRepositories(url));
            }
            catch (IOException e) {
                MavenLog.LOG.info((Throwable)e);
            }
        }
        return result;
    }

    public static List<MavenArtifactInfo> findArtifacts(MavenArtifactInfo template, String url) {
        SmartList result = new SmartList();
        for (MavenRepositoryService service : MavenRepositoryServicesManager.getServices()) {
            try {
                result.addAll(service.findArtifacts(url, template));
            }
            catch (IOException e) {
                MavenLog.LOG.info((Throwable)e);
            }
        }
        return result;
    }
}

