/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Transient;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.idea.maven.execution.MavenExecutionOptions;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenGeneralSettings
implements Cloneable {
    private boolean workOffline = false;
    private String mavenHome = "";
    private String mavenSettingsFile = "";
    private String overriddenLocalRepository = "";
    private boolean printErrorStackTraces = false;
    private boolean usePluginRegistry = false;
    private boolean nonRecursive = false;
    private boolean alwaysUpdateSnapshots = false;
    private String threads;
    private MavenExecutionOptions.LoggingLevel outputLevel = MavenExecutionOptions.LoggingLevel.INFO;
    private MavenExecutionOptions.ChecksumPolicy checksumPolicy = MavenExecutionOptions.ChecksumPolicy.NOT_SET;
    private MavenExecutionOptions.FailureMode failureBehavior = MavenExecutionOptions.FailureMode.NOT_SET;
    private MavenExecutionOptions.PluginUpdatePolicy pluginUpdatePolicy = MavenExecutionOptions.PluginUpdatePolicy.DEFAULT;
    private File myEffectiveLocalRepositoryCache;
    private Set<String> myDefaultPluginsCache;
    private int myBulkUpdateLevel = 0;
    private List<Listener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public void beginUpdate() {
        ++this.myBulkUpdateLevel;
    }

    public void endUpdate() {
        if (--this.myBulkUpdateLevel == 0) {
            this.changed();
        }
    }

    public void changed() {
        if (this.myBulkUpdateLevel > 0) {
            return;
        }
        this.myEffectiveLocalRepositoryCache = null;
        this.myDefaultPluginsCache = null;
        this.fireChanged();
    }

    @Property
    public MavenExecutionOptions.PluginUpdatePolicy getPluginUpdatePolicy() {
        return this.pluginUpdatePolicy;
    }

    public void setPluginUpdatePolicy(MavenExecutionOptions.PluginUpdatePolicy value) {
        if (value == null) {
            return;
        }
        this.pluginUpdatePolicy = value;
        this.changed();
    }

    @Property
    public MavenExecutionOptions.ChecksumPolicy getChecksumPolicy() {
        return this.checksumPolicy;
    }

    public void setChecksumPolicy(MavenExecutionOptions.ChecksumPolicy value) {
        if (value == null) {
            return;
        }
        this.checksumPolicy = value;
        this.changed();
    }

    @Property
    public MavenExecutionOptions.FailureMode getFailureBehavior() {
        return this.failureBehavior;
    }

    public void setFailureBehavior(MavenExecutionOptions.FailureMode value) {
        if (value == null) {
            return;
        }
        this.failureBehavior = value;
        this.changed();
    }

    @Transient
    @Deprecated
    public MavenExecutionOptions.LoggingLevel getLoggingLevel() {
        return this.getOutputLevel();
    }

    @Property
    public MavenExecutionOptions.LoggingLevel getOutputLevel() {
        return this.outputLevel;
    }

    public void setOutputLevel(MavenExecutionOptions.LoggingLevel value) {
        if (value == null) {
            return;
        }
        if (!Comparing.equal((Object)((Object)this.outputLevel), (Object)((Object)value))) {
            MavenServerManager.getInstance().setLoggingLevel(value);
            this.outputLevel = value;
            this.changed();
        }
    }

    public boolean isWorkOffline() {
        return this.workOffline;
    }

    public void setWorkOffline(boolean workOffline) {
        this.workOffline = workOffline;
        this.changed();
    }

    public String getMavenHome() {
        return this.mavenHome;
    }

    public void setMavenHome(String mavenHome) {
        if (!Comparing.equal((String)this.mavenHome, (String)mavenHome)) {
            this.mavenHome = mavenHome;
            MavenServerManager.getInstance().setMavenHome(mavenHome);
            this.myDefaultPluginsCache = null;
            this.changed();
        }
    }

    public File getEffectiveMavenHome() {
        return MavenUtil.resolveMavenHomeDirectory(this.getMavenHome());
    }

    public String getUserSettingsFile() {
        return this.mavenSettingsFile;
    }

    public void setUserSettingsFile(String mavenSettingsFile) {
        if (mavenSettingsFile == null) {
            return;
        }
        if (!Comparing.equal((String)this.mavenSettingsFile, (String)mavenSettingsFile)) {
            this.mavenSettingsFile = mavenSettingsFile;
            this.changed();
        }
    }

    public File getEffectiveUserSettingsIoFile() {
        return MavenUtil.resolveUserSettingsFile(this.getUserSettingsFile());
    }

    public File getEffectiveGlobalSettingsIoFile() {
        return MavenUtil.resolveGlobalSettingsFile(this.getMavenHome());
    }

    public VirtualFile getEffectiveUserSettingsFile() {
        File file = this.getEffectiveUserSettingsIoFile();
        return file == null ? null : LocalFileSystem.getInstance().findFileByIoFile(file);
    }

    public List<VirtualFile> getEffectiveSettingsFiles() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>(2);
        VirtualFile file = this.getEffectiveUserSettingsFile();
        if (file != null) {
            result.add(file);
        }
        if ((file = this.getEffectiveGlobalSettingsFile()) != null) {
            result.add(file);
        }
        return result;
    }

    public VirtualFile getEffectiveGlobalSettingsFile() {
        File file = this.getEffectiveGlobalSettingsIoFile();
        return file == null ? null : LocalFileSystem.getInstance().findFileByIoFile(file);
    }

    public String getLocalRepository() {
        return this.overriddenLocalRepository;
    }

    public void setLocalRepository(String overridenLocalRepository) {
        if (overridenLocalRepository == null) {
            return;
        }
        if (!Comparing.equal((String)this.overriddenLocalRepository, (String)overridenLocalRepository)) {
            this.overriddenLocalRepository = overridenLocalRepository;
            MavenServerManager.getInstance().shutdown(true);
            this.changed();
        }
    }

    public File getEffectiveLocalRepository() {
        File result = this.myEffectiveLocalRepositoryCache;
        if (result != null) {
            return result;
        }
        this.myEffectiveLocalRepositoryCache = result = MavenUtil.resolveLocalRepository(this.overriddenLocalRepository, this.mavenHome, this.mavenSettingsFile);
        return result;
    }

    public VirtualFile getEffectiveSuperPom() {
        return MavenUtil.resolveSuperPomFile(this.getEffectiveMavenHome());
    }

    public boolean isDefaultPlugin(String groupId, String artifactId) {
        return this.getDefaultPlugins().contains(groupId + ":" + artifactId);
    }

    private Set<String> getDefaultPlugins() {
        THashSet result = this.myDefaultPluginsCache;
        if (result != null) {
            return result;
        }
        result = new THashSet();
        VirtualFile effectiveSuperPom = this.getEffectiveSuperPom();
        if (effectiveSuperPom != null) {
            Element superProject = MavenJDOMUtil.read(effectiveSuperPom, null);
            for (Element each : MavenJDOMUtil.findChildrenByPath(superProject, "build.pluginManagement.plugins", "plugin")) {
                String groupId = MavenJDOMUtil.findChildValueByPath(each, "groupId", "org.apache.maven.plugins");
                String artifactId = MavenJDOMUtil.findChildValueByPath(each, "artifactId", null);
                result.add(groupId + ":" + artifactId);
            }
        }
        this.myDefaultPluginsCache = result;
        return result;
    }

    public boolean isPrintErrorStackTraces() {
        return this.printErrorStackTraces;
    }

    public void setPrintErrorStackTraces(boolean value) {
        this.printErrorStackTraces = value;
        this.changed();
    }

    public boolean isUsePluginRegistry() {
        return this.usePluginRegistry;
    }

    public void setUsePluginRegistry(boolean usePluginRegistry) {
        this.usePluginRegistry = usePluginRegistry;
        this.changed();
    }

    public boolean isAlwaysUpdateSnapshots() {
        return this.alwaysUpdateSnapshots;
    }

    public void setAlwaysUpdateSnapshots(boolean alwaysUpdateSnapshots) {
        this.alwaysUpdateSnapshots = alwaysUpdateSnapshots;
        this.changed();
    }

    public boolean isNonRecursive() {
        return this.nonRecursive;
    }

    public void setNonRecursive(boolean nonRecursive) {
        this.nonRecursive = nonRecursive;
        this.changed();
    }

    public String getThreads() {
        return this.threads;
    }

    public void setThreads(String threads) {
        this.threads = StringUtil.nullize((String)threads);
        this.changed();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenGeneralSettings that = (MavenGeneralSettings)o;
        if (this.nonRecursive != that.nonRecursive) {
            return false;
        }
        if (this.outputLevel != that.outputLevel) {
            return false;
        }
        if (this.pluginUpdatePolicy != that.pluginUpdatePolicy) {
            return false;
        }
        if (this.alwaysUpdateSnapshots != that.alwaysUpdateSnapshots) {
            return false;
        }
        if (this.printErrorStackTraces != that.printErrorStackTraces) {
            return false;
        }
        if (this.usePluginRegistry != that.usePluginRegistry) {
            return false;
        }
        if (this.workOffline != that.workOffline) {
            return false;
        }
        if (!this.checksumPolicy.equals((Object)that.checksumPolicy)) {
            return false;
        }
        if (!this.failureBehavior.equals((Object)that.failureBehavior)) {
            return false;
        }
        if (!this.overriddenLocalRepository.equals(that.overriddenLocalRepository)) {
            return false;
        }
        if (!this.mavenHome.equals(that.mavenHome)) {
            return false;
        }
        if (!this.mavenSettingsFile.equals(that.mavenSettingsFile)) {
            return false;
        }
        return Comparing.equal((String)this.threads, (String)that.threads);
    }

    public int hashCode() {
        int result = this.workOffline ? 1 : 0;
        result = 31 * result + this.mavenHome.hashCode();
        result = 31 * result + this.mavenSettingsFile.hashCode();
        result = 31 * result + this.overriddenLocalRepository.hashCode();
        result = 31 * result + (this.printErrorStackTraces ? 1 : 0);
        result = 31 * result + (this.usePluginRegistry ? 1 : 0);
        result = 31 * result + (this.nonRecursive ? 1 : 0);
        result = 31 * result + this.outputLevel.hashCode();
        result = 31 * result + this.checksumPolicy.hashCode();
        result = 31 * result + this.failureBehavior.hashCode();
        result = 31 * result + this.pluginUpdatePolicy.hashCode();
        return result;
    }

    public MavenGeneralSettings clone() {
        try {
            MavenGeneralSettings result = (MavenGeneralSettings)super.clone();
            result.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
            result.myBulkUpdateLevel = 0;
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public void addListener(Listener l) {
        this.myListeners.add(l);
    }

    public void removeListener(Listener l) {
        this.myListeners.remove(l);
    }

    private void fireChanged() {
        for (Listener each : this.myListeners) {
            each.changed();
        }
    }

    public static interface Listener {
        public void changed();
    }
}

