/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.idea.maven.indices.MavenIndex;
import org.jetbrains.idea.maven.indices.MavenIndexException;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.server.MavenIndexerWrapper;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;

public class MavenIndices {
    private final MavenIndexerWrapper myIndexer;
    private final File myIndicesDir;
    private final MavenIndex.IndexListener myListener;
    private final List<MavenIndex> myIndices = new ArrayList<MavenIndex>();
    private static final Object ourDirectoryLock = new Object();

    public MavenIndices(MavenIndexerWrapper indexer, File indicesDir, MavenIndex.IndexListener listener) {
        this.myIndexer = indexer;
        this.myIndicesDir = indicesDir;
        this.myListener = listener;
        this.load();
    }

    private void load() {
        Object[] indices = this.myIndicesDir.listFiles();
        if (indices == null) {
            return;
        }
        Arrays.sort(indices);
        for (Object each : indices) {
            if (!((File)each).isDirectory()) continue;
            try {
                MavenIndex index = new MavenIndex(this.myIndexer, (File)each, this.myListener);
                if (this.find(index.getRepositoryPathOrUrl(), index.getKind()) != null) {
                    index.close(true);
                    FileUtil.delete((File)each);
                    continue;
                }
                this.myIndices.add(index);
            }
            catch (Exception e) {
                FileUtil.delete((File)each);
                MavenLog.LOG.warn((Throwable)e);
            }
        }
    }

    public synchronized void close() {
        for (MavenIndex each : this.myIndices) {
            each.close(false);
        }
        this.myIndices.clear();
    }

    public synchronized List<MavenIndex> getIndices() {
        return new ArrayList<MavenIndex>(this.myIndices);
    }

    public synchronized MavenIndex add(String repositoryId, String repositoryPathOrUrl, MavenIndex.Kind kind) throws MavenIndexException {
        MavenIndex index = this.find(repositoryPathOrUrl, kind);
        if (index != null) {
            index.registerId(repositoryId);
            return index;
        }
        File dir = this.createNewIndexDir();
        index = new MavenIndex(this.myIndexer, dir, repositoryId, repositoryPathOrUrl, kind, this.myListener);
        this.myIndices.add(index);
        return index;
    }

    @Deprecated
    public MavenIndex find(String repositoryId, String repositoryPathOrUrl, MavenIndex.Kind kind) {
        for (MavenIndex each : this.myIndices) {
            if (!each.isFor(kind, repositoryPathOrUrl)) continue;
            return each;
        }
        return null;
    }

    public MavenIndex find(String repositoryPathOrUrl, MavenIndex.Kind kind) {
        for (MavenIndex each : this.myIndices) {
            if (!each.isFor(kind, repositoryPathOrUrl)) continue;
            return each;
        }
        return null;
    }

    private File createNewIndexDir() {
        return MavenIndices.createNewDir(this.myIndicesDir, "Index", 1000);
    }

    static File createNewDir(File parent, String prefix, int max) {
        Object object = ourDirectoryLock;
        synchronized (object) {
            for (int i = 0; i < max; ++i) {
                boolean createSuccessFull;
                String name = prefix + i;
                File f = new File(parent, name);
                if (f.exists() || !(createSuccessFull = f.mkdirs())) continue;
                return f;
            }
            throw new RuntimeException("No available dir found");
        }
    }

    public static void updateOrRepair(MavenIndex index, boolean fullUpdate, MavenGeneralSettings settings, MavenProgressIndicator progress) throws MavenProcessCanceledException {
        index.updateOrRepair(fullUpdate, settings, progress);
    }
}

