/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing.configurers;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.compiler.options.ExcludeEntryDescription;
import com.intellij.openapi.compiler.options.ExcludesConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import org.jetbrains.idea.maven.importing.configurers.MavenModuleConfigurer;
import org.jetbrains.idea.maven.project.MavenProject;

public class MavenCompilerConfigurer
extends MavenModuleConfigurer {
    public static final Key<Boolean> IGNORE_MAVEN_COMPILER_TARGET_KEY = Key.create((String)"idea.maven.skip.compiler.target.level");

    @Override
    public void configure(MavenProject mavenProject, Project project, Module module) {
        if (module == null) {
            return;
        }
        CompilerConfiguration configuration = CompilerConfiguration.getInstance((Project)project);
        if (!Boolean.TRUE.equals(module.getUserData(IGNORE_MAVEN_COMPILER_TARGET_KEY))) {
            String targetLevel = mavenProject.getTargetLevel();
            configuration.setBytecodeTargetLevel(module, (String)ObjectUtils.notNull((Object)targetLevel, (Object)"1.5"));
        }
        module.putUserData(IGNORE_MAVEN_COMPILER_TARGET_KEY, (Object)Boolean.FALSE);
        VirtualFile dir = VfsUtil.findRelativeFile((VirtualFile)mavenProject.getDirectoryFile(), (String[])new String[]{"src", "main", "resources", "archetype-resources"});
        if (dir != null && !configuration.isExcludedFromCompilation(dir)) {
            ExcludesConfiguration cfg = configuration.getExcludedEntriesConfiguration();
            cfg.addExcludeEntryDescription(new ExcludeEntryDescription(dir, true, false, (Disposable)project));
        }
    }
}

