/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetModel;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactModel;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.ManifestFileProvider;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.DefaultManifestFileProvider;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jetbrains.idea.maven.importing.ArtifactExternalDependenciesImporter;
import org.jetbrains.idea.maven.importing.MavenModifiableModelsProvider;

public abstract class MavenBaseModifiableModelsProvider
implements MavenModifiableModelsProvider {
    protected ModifiableModuleModel myModuleModel;
    protected Map<Module, ModifiableRootModel> myRootModels = new THashMap();
    protected Map<Module, ModifiableFacetModel> myFacetModels = new THashMap();
    protected Map<Library, Library.ModifiableModel> myLibraryModels = new IdentityHashMap<Library, Library.ModifiableModel>();
    protected ModifiableArtifactModel myArtifactModel;
    protected final Project myProject;
    private MyPackagingElementResolvingContext myPackagingElementResolvingContext;
    private final ArtifactExternalDependenciesImporter myArtifactExternalDependenciesImporter;

    public MavenBaseModifiableModelsProvider(Project project) {
        this.myProject = project;
        this.myArtifactExternalDependenciesImporter = new ArtifactExternalDependenciesImporter();
    }

    @Override
    public ModifiableModuleModel getModuleModel() {
        if (this.myModuleModel == null) {
            this.myModuleModel = this.doGetModuleModel();
        }
        return this.myModuleModel;
    }

    @Override
    public ModifiableRootModel getRootModel(Module module) {
        ModifiableRootModel result = this.myRootModels.get(module);
        if (result == null) {
            result = this.doGetRootModel(module);
            this.myRootModels.put(module, result);
        }
        return result;
    }

    @Override
    public ModifiableFacetModel getFacetModel(Module module) {
        ModifiableFacetModel result = this.myFacetModels.get(module);
        if (result == null) {
            result = this.doGetFacetModel(module);
            this.myFacetModels.put(module, result);
        }
        return result;
    }

    @Override
    public ModifiableArtifactModel getArtifactModel() {
        if (this.myArtifactModel == null) {
            this.myArtifactModel = this.doGetArtifactModel();
        }
        return this.myArtifactModel;
    }

    @Override
    public PackagingElementResolvingContext getPackagingElementResolvingContext() {
        if (this.myPackagingElementResolvingContext == null) {
            this.myPackagingElementResolvingContext = new MyPackagingElementResolvingContext();
        }
        return this.myPackagingElementResolvingContext;
    }

    @Override
    public ArtifactExternalDependenciesImporter getArtifactExternalDependenciesImporter() {
        return this.myArtifactExternalDependenciesImporter;
    }

    @Override
    public Library.ModifiableModel getLibraryModel(Library library) {
        Library.ModifiableModel result = this.myLibraryModels.get(library);
        if (result == null) {
            result = this.doGetLibraryModel(library);
            this.myLibraryModels.put(library, result);
        }
        return result;
    }

    @Override
    public String[] getLibraryUrls(Library library, OrderRootType type) {
        Library.ModifiableModel model = this.myLibraryModels.get(library);
        if (model != null) {
            return model.getUrls(type);
        }
        return library.getUrls(type);
    }

    protected abstract ModifiableArtifactModel doGetArtifactModel();

    protected abstract ModifiableModuleModel doGetModuleModel();

    protected abstract ModifiableRootModel doGetRootModel(Module var1);

    protected abstract ModifiableFacetModel doGetFacetModel(Module var1);

    protected abstract Library.ModifiableModel doGetLibraryModel(Library var1);

    @Override
    public Module[] getModules() {
        return this.getModuleModel().getModules();
    }

    protected void processExternalArtifactDependencies() {
        this.myArtifactExternalDependenciesImporter.applyChanges(this.getArtifactModel(), this.getPackagingElementResolvingContext());
    }

    @Override
    public VirtualFile[] getContentRoots(Module module) {
        return this.getRootModel(module).getContentRoots();
    }

    private class MavenFacetsProvider
    implements FacetsProvider {
        private MavenFacetsProvider() {
        }

        public Facet[] getAllFacets(Module module) {
            return MavenBaseModifiableModelsProvider.this.getFacetModel(module).getAllFacets();
        }

        public <F extends Facet> Collection<F> getFacetsByType(Module module, FacetTypeId<F> type) {
            return MavenBaseModifiableModelsProvider.this.getFacetModel(module).getFacetsByType(type);
        }

        public <F extends Facet> F findFacet(Module module, FacetTypeId<F> type, String name) {
            return (F)MavenBaseModifiableModelsProvider.this.getFacetModel(module).findFacet(type, name);
        }
    }

    private class MavenModulesProvider
    implements ModulesProvider {
        private MavenModulesProvider() {
        }

        public Module[] getModules() {
            return MavenBaseModifiableModelsProvider.this.getModuleModel().getModules();
        }

        public Module getModule(String name) {
            return MavenBaseModifiableModelsProvider.this.getModuleModel().findModuleByName(name);
        }

        public ModuleRootModel getRootModel(Module module) {
            return MavenBaseModifiableModelsProvider.this.getRootModel(module);
        }

        public FacetModel getFacetModel(Module module) {
            return MavenBaseModifiableModelsProvider.this.getFacetModel(module);
        }
    }

    private class MyPackagingElementResolvingContext
    implements PackagingElementResolvingContext {
        private final ModulesProvider myModulesProvider;
        private final MavenFacetsProvider myFacetsProvider;
        private final DefaultManifestFileProvider myManifestFileProvider;

        private MyPackagingElementResolvingContext() {
            this.myModulesProvider = new MavenModulesProvider();
            this.myFacetsProvider = new MavenFacetsProvider();
            this.myManifestFileProvider = new DefaultManifestFileProvider((PackagingElementResolvingContext)this);
        }

        public Project getProject() {
            return MavenBaseModifiableModelsProvider.this.myProject;
        }

        public ArtifactModel getArtifactModel() {
            return MavenBaseModifiableModelsProvider.this.getArtifactModel();
        }

        public ModulesProvider getModulesProvider() {
            return this.myModulesProvider;
        }

        public FacetsProvider getFacetsProvider() {
            return this.myFacetsProvider;
        }

        public Library findLibrary(String level, String libraryName) {
            if (level.equals("project")) {
                return MavenBaseModifiableModelsProvider.this.getLibraryByName(libraryName);
            }
            LibraryTable table = LibraryTablesRegistrar.getInstance().getLibraryTableByLevel(level, MavenBaseModifiableModelsProvider.this.myProject);
            return table != null ? table.getLibraryByName(libraryName) : null;
        }

        public ManifestFileProvider getManifestFileProvider() {
            return this.myManifestFileProvider;
        }
    }
}

