/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.roots.DependencyScope;
import org.jdom.Element;
import org.jetbrains.idea.maven.importing.MavenModuleImporter;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.utils.ManifestBuilder;

public abstract class ManifestImporter {
    public static ExtensionPointName<ManifestImporter> EXTENSION_POINT_NAME = ExtensionPointName.create((String)"org.jetbrains.idea.maven.manifestImporter");

    public static ManifestImporter getManifestImporter(String packaging) {
        for (ManifestImporter importer : (ManifestImporter[])EXTENSION_POINT_NAME.getExtensions()) {
            if (!importer.isApplicable(packaging)) continue;
            return importer;
        }
        return new DefaultManifestImporter();
    }

    public String getClasspath(MavenProject mavenProject, Element manifestConfiguration) {
        StringBuilder classpath = new StringBuilder();
        String classpathPrefix = ManifestBuilder.getClasspathPrefix(manifestConfiguration);
        for (MavenArtifact mavenArtifact : mavenProject.getDependencies()) {
            DependencyScope scope = MavenModuleImporter.selectScope(mavenArtifact.getScope());
            if (!scope.isForProductionRuntime()) continue;
            if (classpath.length() > 0) {
                classpath.append(" ");
            }
            classpath.append(classpathPrefix);
            String artifactFileName = mavenArtifact.getArtifactId() + "-" + mavenArtifact.getVersion() + "." + mavenArtifact.getExtension();
            classpath.append(this.doGetClasspathItem(mavenProject, mavenArtifact, artifactFileName));
        }
        return classpath.toString();
    }

    protected abstract boolean isApplicable(String var1);

    protected abstract String doGetClasspathItem(MavenProject var1, MavenArtifact var2, String var3);

    private static class DefaultManifestImporter
    extends ManifestImporter {
        private DefaultManifestImporter() {
        }

        @Override
        protected boolean isApplicable(String packaging) {
            return true;
        }

        @Override
        protected String doGetClasspathItem(MavenProject mavenProject, MavenArtifact mavenArtifact, String artifactFileName) {
            return artifactFileName;
        }
    }
}

