/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.references;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public abstract class MavenPsiReference
implements PsiReference {
    protected final Project myProject;
    protected final MavenProjectsManager myProjectsManager;
    protected final PsiFile myPsiFile;
    protected final VirtualFile myVirtualFile;
    protected final PsiElement myElement;
    protected final String myText;
    protected final TextRange myRange;

    public MavenPsiReference(PsiElement element, String text, TextRange range) {
        this.myProject = element.getProject();
        this.myProjectsManager = MavenProjectsManager.getInstance(this.myProject);
        this.myPsiFile = element.getContainingFile().getOriginalFile();
        this.myVirtualFile = this.myPsiFile.getVirtualFile();
        this.myElement = element;
        this.myText = text;
        this.myRange = range;
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    public String getCanonicalText() {
        return this.myText;
    }

    public TextRange getRangeInElement() {
        return this.myRange;
    }

    public boolean isReferenceTo(PsiElement element) {
        return this.getElement().getManager().areElementsEquivalent(element, this.resolve());
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return null;
    }

    public PsiElement bindToElement(PsiElement element) throws IncorrectOperationException {
        return null;
    }

    public boolean isSoft() {
        return true;
    }
}

