/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.references;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.Function;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.converters.PathReferenceConverter;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.idea.maven.dom.MavenPropertyResolver;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;

public class MavenPathReferenceConverter
extends PathReferenceConverter {
    private final Condition<PsiFileSystemItem> myCondition;

    public MavenPathReferenceConverter() {
        this((Condition<PsiFileSystemItem>)Conditions.alwaysTrue());
    }

    public MavenPathReferenceConverter(Condition<PsiFileSystemItem> condition) {
        this.myCondition = condition;
    }

    public static PsiReference[] createReferences(DomElement genericDomValue, PsiElement element, Condition<PsiFileSystemItem> fileFilter) {
        return MavenPathReferenceConverter.createReferences(genericDomValue, element, fileFilter, false);
    }

    public static PsiReference[] createReferences(final DomElement genericDomValue, PsiElement element, final Condition<PsiFileSystemItem> fileFilter, boolean isAbsolutePath) {
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)element);
        TextRange range = manipulator.getRangeInElement(element);
        String text = range.substring(element.getText());
        FileReferenceSet set = new FileReferenceSet(text, element, range.getStartOffset(), null, SystemInfo.isFileSystemCaseSensitive, false){
            private MavenDomProjectModel model;

            protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
                return fileFilter;
            }

            protected boolean isSoft() {
                return true;
            }

            public FileReference createFileReference(TextRange range, int index, String text) {
                return new FileReference(this, range, index, text){

                    protected void innerResolveInContext(String text, PsiFileSystemItem context, Collection<ResolveResult> result, boolean caseSensitive) {
                        String resolvedText;
                        DomElement rootElement;
                        if (model == null && (rootElement = DomUtil.getFileElement((DomElement)genericDomValue).getRootElement()) instanceof MavenDomProjectModel) {
                            model = (MavenDomProjectModel)rootElement;
                        }
                        String string = resolvedText = model == null ? text : MavenPropertyResolver.resolve(text, model);
                        if (resolvedText.equals(text)) {
                            if (this.getIndex() == 0 && resolvedText.length() == 2 && resolvedText.charAt(1) == ':') {
                                PsiDirectory psiDirectory;
                                VirtualFile file = LocalFileSystem.getInstance().findFileByPath(resolvedText + '/');
                                if (file != null && (psiDirectory = context.getManager().findDirectory(file)) != null) {
                                    result.add((ResolveResult)new PsiElementResolveResult((PsiElement)psiDirectory));
                                }
                            } else {
                                super.innerResolveInContext(resolvedText, context, result, caseSensitive);
                            }
                        } else {
                            VirtualFile contextFile = context.getVirtualFile();
                            if (contextFile == null) {
                                return;
                            }
                            VirtualFile file = null;
                            if (this.getIndex() == 0) {
                                file = LocalFileSystem.getInstance().findFileByPath(resolvedText);
                            }
                            if (file == null) {
                                file = LocalFileSystem.getInstance().findFileByPath(contextFile.getPath() + '/' + resolvedText);
                            }
                            if (file != null) {
                                PsiDirectory res;
                                Object object = res = file.isDirectory() ? context.getManager().findDirectory(file) : context.getManager().findFile(file);
                                if (res != null) {
                                    result.add((ResolveResult)new PsiElementResolveResult((PsiElement)res));
                                }
                            }
                        }
                    }
                };
            }
        };
        if (isAbsolutePath) {
            set.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, (Object)new Function<PsiFile, Collection<PsiFileSystemItem>>(){

                public Collection<PsiFileSystemItem> fun(PsiFile file) {
                    VirtualFile parent;
                    VirtualFile virtualFile = file.getVirtualFile();
                    if (virtualFile == null) {
                        return (Collection)FileReferenceSet.ABSOLUTE_TOP_LEVEL.fun((Object)file);
                    }
                    while ((parent = virtualFile.getParent()) != null) {
                        virtualFile = parent;
                    }
                    PsiDirectory root = file.getManager().findDirectory(virtualFile);
                    if (root == null) {
                        return (Collection)FileReferenceSet.ABSOLUTE_TOP_LEVEL.fun((Object)file);
                    }
                    return Collections.singletonList(root);
                }
            });
        }
        return set.getAllReferences();
    }

    public PsiReference[] createReferences(GenericDomValue genericDomValue, PsiElement element, ConvertContext context) {
        return MavenPathReferenceConverter.createReferences((DomElement)genericDomValue, element, this.myCondition);
    }

    public PsiReference[] createReferences(PsiElement psiElement, boolean soft) {
        throw new UnsupportedOperationException();
    }
}

