/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import org.jetbrains.idea.maven.indices.MavenProjectIndicesManager;
import org.jetbrains.idea.maven.plugins.api.MavenSoftAwareReferenceProvider;

public class MavenDependencyReferenceProvider
extends PsiReferenceProvider
implements MavenSoftAwareReferenceProvider {
    private boolean mySoft = true;
    private boolean myCanHasVersion = true;

    public PsiReference[] getReferencesByElement(PsiElement element, ProcessingContext context) {
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)element);
        TextRange range = manipulator.getRangeInElement(element);
        String text = range.substring(element.getText());
        int firstDelim = text.indexOf(58);
        if (firstDelim == -1) {
            return new PsiReference[]{new GroupReference(element, range, this.mySoft)};
        }
        int secondDelim = this.myCanHasVersion ? text.indexOf(58, firstDelim + 1) : -1;
        int start = range.getStartOffset();
        if (secondDelim == -1) {
            return new PsiReference[]{new GroupReference(element, new TextRange(start, start + firstDelim), this.mySoft), new ArtifactReference(text.substring(0, firstDelim), element, new TextRange(start + firstDelim + 1, range.getEndOffset()), this.mySoft)};
        }
        int lastDelim = text.indexOf(secondDelim + 1);
        if (lastDelim == -1) {
            lastDelim = text.length();
        }
        return new PsiReference[]{new GroupReference(element, new TextRange(start, start + firstDelim), this.mySoft), new ArtifactReference(text.substring(0, firstDelim), element, new TextRange(start + firstDelim + 1, start + secondDelim), this.mySoft), new VersionReference(text.substring(0, firstDelim), text.substring(firstDelim + 1, secondDelim), element, new TextRange(start + secondDelim + 1, start + lastDelim), this.mySoft)};
    }

    @Override
    public void setSoft(boolean soft) {
        this.mySoft = soft;
    }

    public boolean isCanHasVersion() {
        return this.myCanHasVersion;
    }

    public void setCanHasVersion(boolean canHasVersion) {
        this.myCanHasVersion = canHasVersion;
    }

    public static class VersionReference
    extends PsiReferenceBase<PsiElement> {
        private final String myGroupId;
        private final String myArtifactId;

        public VersionReference(String groupId, String artifactId, PsiElement element, TextRange range, boolean soft) {
            super(element, range, soft);
            this.myGroupId = groupId;
            this.myArtifactId = artifactId;
        }

        public PsiElement resolve() {
            return null;
        }

        public Object[] getVariants() {
            if (StringUtil.isEmptyOrSpaces((String)this.myGroupId) || StringUtil.isEmptyOrSpaces((String)this.myArtifactId)) {
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }
            MavenProjectIndicesManager manager = MavenProjectIndicesManager.getInstance(this.getElement().getProject());
            return manager.getVersions(this.myGroupId, this.myArtifactId).toArray();
        }
    }

    public static class ArtifactReference
    extends PsiReferenceBase<PsiElement> {
        private final String myGroupId;

        public ArtifactReference(String groupId, PsiElement element, TextRange range, boolean soft) {
            super(element, range, soft);
            this.myGroupId = groupId;
        }

        public PsiElement resolve() {
            return null;
        }

        public Object[] getVariants() {
            if (StringUtil.isEmptyOrSpaces((String)this.myGroupId)) {
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }
            MavenProjectIndicesManager manager = MavenProjectIndicesManager.getInstance(this.getElement().getProject());
            return manager.getArtifactIds(this.myGroupId).toArray();
        }
    }

    private static class GroupReference
    extends PsiReferenceBase<PsiElement> {
        public GroupReference(PsiElement element, TextRange range, boolean soft) {
            super(element, range, soft);
        }

        public PsiElement resolve() {
            return null;
        }

        public Object[] getVariants() {
            return MavenProjectIndicesManager.getInstance(this.getElement().getProject()).getGroupIds().toArray();
        }
    }
}

