/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.refactorings.extract;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlElement;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.util.Function;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.xml.DomUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.idea.maven.dom.DependencyConflictId;
import org.jetbrains.idea.maven.dom.MavenDomProjectProcessorUtils;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomExclusion;
import org.jetbrains.idea.maven.dom.model.MavenDomExclusions;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.refactorings.extract.SelectMavenProjectDialog;

public class ExtractManagedDependenciesAction
extends BaseRefactoringAction {
    public ExtractManagedDependenciesAction() {
        this.setInjectedContext(true);
    }

    protected boolean isAvailableInEditorOnly() {
        return true;
    }

    protected boolean isEnabledOnElements(PsiElement[] elements) {
        return false;
    }

    protected boolean isAvailableForLanguage(Language language) {
        return true;
    }

    protected RefactoringActionHandler getHandler(DataContext dataContext) {
        return new MyRefactoringActionHandler();
    }

    protected boolean isAvailableForFile(PsiFile file) {
        return MavenDomUtil.isMavenFile(file);
    }

    protected boolean isAvailableOnElementInEditorAndFile(PsiElement element, Editor editor, PsiFile file, DataContext context) {
        if (!super.isAvailableOnElementInEditorAndFile(element, editor, file, context)) {
            return false;
        }
        return ExtractManagedDependenciesAction.findDependencyAndParent(file, editor) != null;
    }

    private static Pair<MavenDomDependency, Set<MavenDomProjectModel>> findDependencyAndParent(PsiFile file, Editor editor) {
        MavenDomDependency dependency = (MavenDomDependency)DomUtil.findDomElement((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), MavenDomDependency.class);
        if (dependency == null || ExtractManagedDependenciesAction.isManagedDependency(dependency)) {
            return null;
        }
        Set<MavenDomProjectModel> parents = ExtractManagedDependenciesAction.getParentProjects(file);
        if (parents.isEmpty()) {
            return null;
        }
        return Pair.create((Object)dependency, parents);
    }

    private static Set<MavenDomProjectModel> getParentProjects(PsiFile file) {
        MavenDomProjectModel model = MavenDomUtil.getMavenDomModel(file, MavenDomProjectModel.class);
        if (model == null) {
            return Collections.emptySet();
        }
        return MavenDomProjectProcessorUtils.collectParentProjects(model);
    }

    private static boolean isManagedDependency(MavenDomDependency dependency) {
        return MavenDomProjectProcessorUtils.searchManagingDependency(dependency) != null;
    }

    private static class ProcessData {
        private final MavenDomProjectModel myModel;
        private final Set<MavenDomDependency> myUsages;
        private final boolean myExtractExclusions;

        public MavenDomProjectModel getModel() {
            return this.myModel;
        }

        public Set<MavenDomDependency> getUsages() {
            return this.myUsages;
        }

        public boolean isExtractExclusions() {
            return this.myExtractExclusions;
        }

        public ProcessData(MavenDomProjectModel model, Set<MavenDomDependency> usages, boolean extractExclusions) {
            this.myModel = model;
            this.myUsages = usages;
            this.myExtractExclusions = extractExclusions;
        }
    }

    private static class MyRefactoringActionHandler
    implements RefactoringActionHandler {
        private MyRefactoringActionHandler() {
        }

        public void invoke(Project project, Editor editor, PsiFile file, DataContext dataContext) {
            Pair depAndParents = ExtractManagedDependenciesAction.findDependencyAndParent(file, editor);
            if (depAndParents == null) {
                return;
            }
            Set parent = (Set)depAndParents.second;
            final MavenDomDependency dependency = (MavenDomDependency)depAndParents.first;
            Function<MavenDomProjectModel, Set<MavenDomDependency>> funOccurrences = MyRefactoringActionHandler.getOccurencesFunction(dependency);
            ProcessData processData = MyRefactoringActionHandler.getProcessData(project, parent, funOccurrences, dependency.getExclusions().getXmlElement() != null);
            if (processData == null) {
                return;
            }
            final MavenDomProjectModel model = processData.getModel();
            final Set<MavenDomDependency> usages = processData.getUsages();
            final boolean extractExclusions = processData.isExtractExclusions();
            assert (model != null);
            assert (usages != null);
            new WriteCommandAction(project, MyRefactoringActionHandler.getFiles(file, model, usages)){

                protected void run(Result result) throws Throwable {
                    String systemPath;
                    String classifier;
                    MavenDomDependency addedDependency = model.getDependencyManagement().getDependencies().addDependency();
                    addedDependency.getGroupId().setStringValue(dependency.getGroupId().getStringValue());
                    addedDependency.getArtifactId().setStringValue(dependency.getArtifactId().getStringValue());
                    addedDependency.getVersion().setStringValue(dependency.getVersion().getStringValue());
                    String typeValue = dependency.getType().getStringValue();
                    dependency.getVersion().undefine();
                    if (typeValue != null) {
                        addedDependency.getType().setStringValue(typeValue);
                    }
                    if ((classifier = dependency.getClassifier().getStringValue()) != null) {
                        addedDependency.getClassifier().setStringValue(classifier);
                    }
                    if ((systemPath = dependency.getSystemPath().getStringValue()) != null) {
                        addedDependency.getSystemPath().setStringValue(systemPath);
                        dependency.getSystemPath().undefine();
                    }
                    if (extractExclusions) {
                        MavenDomExclusions addedExclusions = addedDependency.getExclusions();
                        for (MavenDomExclusion exclusion : dependency.getExclusions().getExclusions()) {
                            MavenDomExclusion domExclusion = addedExclusions.addExclusion();
                            domExclusion.getGroupId().setStringValue(exclusion.getGroupId().getStringValue());
                            domExclusion.getArtifactId().setStringValue(exclusion.getArtifactId().getStringValue());
                        }
                        dependency.getExclusions().undefine();
                    }
                    for (MavenDomDependency usage : usages) {
                        usage.getVersion().undefine();
                    }
                }
            }.execute();
        }

        private static PsiFile[] getFiles(PsiFile file, MavenDomProjectModel model, Set<MavenDomDependency> usages) {
            HashSet files = new HashSet();
            files.add(file);
            XmlElement xmlElement = model.getXmlElement();
            if (xmlElement != null) {
                files.add(xmlElement.getContainingFile());
            }
            for (MavenDomDependency usage : usages) {
                XmlElement element = usage.getXmlElement();
                if (element == null) continue;
                files.add(element.getContainingFile());
            }
            return PsiUtilCore.toPsiFileArray((Collection)files);
        }

        private static ProcessData getProcessData(Project project, Set<MavenDomProjectModel> models, Function<MavenDomProjectModel, Set<MavenDomDependency>> funOccurrences, boolean hasExclusions) {
            MavenDomProjectModel model;
            if (models.size() == 0) {
                return null;
            }
            if (models.size() == 1 && !hasExclusions && ((Set)funOccurrences.fun((Object)(model = models.iterator().next()))).size() == 0) {
                return new ProcessData(model, Collections.<MavenDomDependency>emptySet(), false);
            }
            SelectMavenProjectDialog dialog = new SelectMavenProjectDialog(project, models, funOccurrences, hasExclusions);
            dialog.show();
            if (dialog.getExitCode() == 0) {
                MavenDomProjectModel model2 = dialog.getSelectedProject();
                return new ProcessData(model2, dialog.isReplaceAllOccurrences() ? (Set)funOccurrences.fun((Object)model2) : Collections.emptySet(), dialog.isExtractExclusions());
            }
            return null;
        }

        private static Function<MavenDomProjectModel, Set<MavenDomDependency>> getOccurencesFunction(final MavenDomDependency dependency) {
            return new Function<MavenDomProjectModel, Set<MavenDomDependency>>(){

                public Set<MavenDomDependency> fun(MavenDomProjectModel model) {
                    DependencyConflictId dependencyId = DependencyConflictId.create(dependency);
                    if (dependencyId == null) {
                        return Collections.emptySet();
                    }
                    return MavenDomProjectProcessorUtils.searchDependencyUsages(model, dependencyId, Collections.singleton(dependency));
                }
            };
        }

        public void invoke(Project project, PsiElement[] elements, DataContext dataContext) {
        }
    }
}

