/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.model.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.SmartList;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.impl.GenericDomValueReference;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.converters.MavenSmartConverter;
import org.jetbrains.idea.maven.dom.references.MavenPropertyCompletionContributor;

public class MavenSmartCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(CompletionParameters parameters, CompletionResultSet result) {
        if (parameters.getCompletionType() != CompletionType.SMART) {
            return;
        }
        Collection<?> variants = MavenSmartCompletionContributor.getVariants(parameters);
        MavenPropertyCompletionContributor.addVariants(variants, result);
    }

    private static Collection<?> getVariants(CompletionParameters parameters) {
        if (!MavenDomUtil.isMavenFile(parameters.getOriginalFile())) {
            return Collections.emptyList();
        }
        SmartList result = new SmartList();
        for (PsiReference each : MavenSmartCompletionContributor.getReferences(parameters)) {
            if (each instanceof TagNameReference) continue;
            if (each instanceof GenericDomValueReference) {
                GenericDomValueReference reference = (GenericDomValueReference)each;
                Converter converter = reference.getConverter();
                if (converter instanceof MavenSmartConverter) {
                    Collection variants = ((MavenSmartConverter)converter).getSmartVariants(reference.getConvertContext());
                    if (converter instanceof ResolvingConverter) {
                        MavenSmartCompletionContributor.addVariants((ResolvingConverter)converter, variants, (Collection)result);
                        continue;
                    }
                    result.addAll(variants);
                    continue;
                }
                if (!(converter instanceof ResolvingConverter)) continue;
                ResolvingConverter resolvingConverter = (ResolvingConverter)converter;
                Collection variants = resolvingConverter.getVariants(reference.getConvertContext());
                MavenSmartCompletionContributor.addVariants(resolvingConverter, variants, (Collection)result);
                continue;
            }
            Collections.addAll(result, each.getVariants());
        }
        return result;
    }

    private static <T> void addVariants(ResolvingConverter<T> converter, Collection<T> variants, Collection result) {
        for (T variant : variants) {
            LookupElement lookupElement = converter.createLookupElement(variant);
            if (lookupElement != null) {
                result.add(lookupElement);
                continue;
            }
            result.add(variant);
        }
    }

    private static PsiReference[] getReferences(CompletionParameters parameters) {
        PsiElement psiElement = parameters.getPosition().getParent();
        return psiElement instanceof XmlText ? psiElement.getParent().getReferences() : psiElement.getReferences();
    }
}

