/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;

public class MavenDuplicatePluginInspection
extends DomElementsInspection<MavenDomProjectModel> {
    public MavenDuplicatePluginInspection() {
        super(MavenDomProjectModel.class, new Class[0]);
    }

    public void checkFileElement(DomFileElement<MavenDomProjectModel> domFileElement, DomElementAnnotationHolder holder) {
        MavenDomProjectModel projectModel = (MavenDomProjectModel)domFileElement.getRootElement();
        MultiMap duplicates = MultiMap.createSet();
        for (MavenDomPlugin plugin : projectModel.getBuild().getPlugins().getPlugins()) {
            String groupId = plugin.getGroupId().getStringValue();
            String artifactId = plugin.getArtifactId().getStringValue();
            if (StringUtil.isEmptyOrSpaces((String)artifactId)) continue;
            if ("".equals(groupId) || "org.apache.maven.plugins".equals(groupId) || "org.codehaus.mojo".equals(groupId)) {
                groupId = null;
            }
            duplicates.putValue((Object)Pair.create((Object)groupId, (Object)artifactId), (Object)plugin);
        }
        for (Map.Entry entry : duplicates.entrySet()) {
            Collection set = (Collection)entry.getValue();
            if (set.size() <= 1) continue;
            for (MavenDomPlugin dependency : set) {
                holder.createProblem((DomElement)dependency, HighlightSeverity.WARNING, "Duplicated plugin declaration");
            }
        }
    }

    public String getGroupDisplayName() {
        return MavenDomBundle.message("inspection.group", new Object[0]);
    }

    public String getDisplayName() {
        return MavenDomBundle.message("inspection.duplicate.plugin.declaration", new Object[0]);
    }

    public String getShortName() {
        return "MavenDuplicatePluginInspection";
    }

    public HighlightDisplayLevel getDefaultLevel() {
        return HighlightDisplayLevel.WARNING;
    }
}

