/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters.repositories;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.util.xmlb.XmlSerializer;
import gnu.trove.THashMap;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import org.jetbrains.idea.maven.dom.converters.repositories.beans.RepositoriesBean;
import org.jetbrains.idea.maven.dom.converters.repositories.beans.RepositoryBeanInfo;

public class MavenRepositoriesProvider {
    final Map<String, RepositoryBeanInfo> myRepositoriesMap = new THashMap();

    public static MavenRepositoriesProvider getInstance() {
        return (MavenRepositoriesProvider)ServiceManager.getService(MavenRepositoriesProvider.class);
    }

    public MavenRepositoriesProvider() {
        RepositoriesBean repositoriesBean = (RepositoriesBean)XmlSerializer.deserialize((URL)MavenRepositoriesProvider.class.getResource("repositories.xml"), RepositoriesBean.class);
        assert (repositoriesBean != null);
        RepositoryBeanInfo[] repositories = repositoriesBean.getRepositories();
        assert (repositories != null);
        for (RepositoryBeanInfo repository : repositories) {
            this.registerRepository(repository.getId(), repository);
        }
    }

    public void registerRepository(String id, RepositoryBeanInfo info) {
        this.myRepositoriesMap.put(id, info);
    }

    public Set<String> getRepositoryIds() {
        return this.myRepositoriesMap.keySet();
    }

    public String getRepositoryName(String id) {
        RepositoryBeanInfo pair = this.myRepositoriesMap.get(id);
        return pair != null ? pair.getName() : null;
    }

    public String getRepositoryUrl(String id) {
        RepositoryBeanInfo pair = this.myRepositoriesMap.get(id);
        return pair != null ? pair.getUrl() : null;
    }
}

